define('bitbucket/internal/next/widget/user-avatar/user-avatar', ['module', 'exports', '@atlaskit/avatar', 'classnames', 'prop-types', 'react', 'bitbucket/internal/util/components/react-functional', './user-avatar.less'], function (module, exports, _avatar, _classnames, _propTypes, _react, _reactFunctional) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _avatar2 = _interopRequireDefault(_avatar);

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _objectWithoutProperties(obj, keys) {
        var target = {};

        for (var i in obj) {
            if (keys.indexOf(i) >= 0) continue;
            if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
            target[i] = obj[i];
        }

        return target;
    }

    var UserAvatar = function UserAvatar(_ref) {
        var avatarSrc = _ref.avatarSrc,
            userName = _ref.userName,
            size = _ref.size,
            className = _ref.className,
            props = _objectWithoutProperties(_ref, ['avatarSrc', 'userName', 'size', 'className']);

        return _react2.default.createElement(
            'span',
            _extends({ className: (0, _classnames2.default)('user-avatar', className) }, props),
            _react2.default.createElement(_avatar2.default, { title: userName, size: 'xsmall', src: avatarSrc }),
            _react2.default.createElement(
                'span',
                { className: 'user-avatar-name' },
                userName
            )
        );
    };

    UserAvatar.propTypes = {
        userName: _propTypes.string.isRequired,
        avatarSrc: _propTypes.string.isRequired,
        className: (0, _propTypes.oneOfType)([_propTypes.string, _propTypes.object])
    };

    UserAvatar.defaultProps = {
        className: null
    };

    exports.default = (0, _reactFunctional.pure)(UserAvatar);
    module.exports = exports['default'];
});