define('bitbucket/internal/next/widget/merge-lozenge/merge-lozenge', ['module', 'exports', '@atlaskit/lozenge', '@atlaskit/tooltip', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/util/components/react-functional'], function (module, exports, _lozenge, _tooltip, _aui, _propTypes, _react, _reactFunctional) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _lozenge2 = _interopRequireDefault(_lozenge);

    var _tooltip2 = _interopRequireDefault(_tooltip);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var MergeLozenge = function MergeLozenge(_ref) {
        var abbreviated = _ref.abbreviated,
            showTooltip = _ref.showTooltip;

        var lozenge = _react2.default.createElement(
            _lozenge2.default,
            { appearance: 'default' },
            abbreviated ? _aui.I18n.getText('bitbucket.web.commit.lozenge.merge.abbreviated') : _aui.I18n.getText('bitbucket.web.commit.lozenge.merge')
        );

        if (!showTooltip) {
            return lozenge;
        }

        return _react2.default.createElement(
            _tooltip2.default,
            {
                content: _aui.I18n.getText('bitbucket.web.commit.lozenge.merge.abbreviated.tooltip'),
                tag: 'span'
            },
            lozenge
        );
    };

    MergeLozenge.propTypes = {
        abbreviated: _propTypes.bool,
        showTooltip: _propTypes.bool
    };

    MergeLozenge.defaultProps = {
        abbreviated: true,
        showTooltip: true
    };

    exports.default = (0, _reactFunctional.pure)(MergeLozenge);
    module.exports = exports['default'];
});