define('bitbucket/internal/next/widget/commit-hash/commit-hash', ['module', 'exports', 'classnames', 'prop-types', 'react', 'bitbucket/internal/next/widget/tooltip/commit-message-tooltip', 'bitbucket/internal/util/components/react-functional', './commit-hash.less'], function (module, exports, _classnames, _propTypes, _react, _commitMessageTooltip, _reactFunctional) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    var _commitMessageTooltip2 = _interopRequireDefault(_commitMessageTooltip);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _objectWithoutProperties(obj, keys) {
        var target = {};

        for (var i in obj) {
            if (keys.indexOf(i) >= 0) continue;
            if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
            target[i] = obj[i];
        }

        return target;
    }

    var CommitHash = function CommitHash(_ref) {
        var children = _ref.children,
            message = _ref.message,
            showTooltip = _ref.showTooltip,
            className = _ref.className,
            props = _objectWithoutProperties(_ref, ['children', 'message', 'showTooltip', 'className']);

        var commitHash = _react2.default.createElement(
            'span',
            _extends({ className: (0, _classnames2.default)('commit-hash', className) }, props),
            children
        );

        if (!showTooltip) {
            return commitHash;
        }

        return _react2.default.createElement(
            _commitMessageTooltip2.default,
            { message: message },
            commitHash
        );
    };

    CommitHash.propTypes = {
        children: _propTypes.node.isRequired,
        className: (0, _propTypes.oneOfType)([_propTypes.string, _propTypes.object]),
        showTooltip: _propTypes.bool,
        message: _propTypes.node
    };

    CommitHash.defaultProps = {
        className: null,
        showTooltip: true,
        message: null
    };

    exports.default = (0, _reactFunctional.pure)(CommitHash);
    module.exports = exports['default'];
});