define('bitbucket/internal/next/widget/branch-from-to/branch-from-to', ['module', 'exports', '@atlaskit/icon/glyph/arrow-right', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/next/widget/branch-lozenge/branch-lozenge', 'bitbucket/internal/util/components/react-functional', './branch-from-to.less'], function (module, exports, _arrowRight, _aui, _propTypes, _react, _branchLozenge, _reactFunctional) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _arrowRight2 = _interopRequireDefault(_arrowRight);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _branchLozenge2 = _interopRequireDefault(_branchLozenge);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var BranchFromTo = function BranchFromTo(_ref) {
        var fromRef = _ref.fromRef,
            toRef = _ref.toRef;

        var sameProject = fromRef.repository.project.id === toRef.repository.project.id;
        var sameRepo = fromRef.repository.id === toRef.repository.id;
        var showRepo = sameProject && !sameRepo;

        return _react2.default.createElement(
            'span',
            { className: 'branch-dest' },
            _react2.default.createElement(_branchLozenge2.default, { branch: fromRef, showRepo: showRepo }),
            _react2.default.createElement(
                'span',
                { className: 'arrow' },
                _react2.default.createElement(_arrowRight2.default, {
                    label: _aui.I18n.getText('bitbucket.web.pullrequest.branch.to.arrow.label'),
                    size: 'small'
                })
            ),
            _react2.default.createElement(_branchLozenge2.default, { branch: toRef, showRepo: showRepo })
        );
    };

    BranchFromTo.propsTypes = {
        fromRef: _propTypes2.default.object.isRequired,
        toRef: _propTypes2.default.object.isRequired
    };

    exports.default = (0, _reactFunctional.pure)(BranchFromTo);
    module.exports = exports['default'];
});