define('bitbucket/internal/next/widget/avatar/user-avatar', ['module', 'exports', '@atlaskit/avatar', 'prop-types', 'react', 'bitbucket/util/navbuilder', 'bitbucket/internal/util/components/react-functional'], function (module, exports, _avatar, _propTypes, _react, _navbuilder, _reactFunctional) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _avatar2 = _interopRequireDefault(_avatar);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var getLink = function getLink(user) {
        return _navbuilder2.default.user(user).build() || false;
    };
    var getName = function getName(user) {
        return user.displayName || user.name;
    };

    var UserAvatar = function UserAvatar(_ref) {
        var size = _ref.size,
            person = _ref.person,
            tooltip = _ref.tooltip,
            tooltipText = _ref.tooltipText,
            withLink = _ref.withLink;

        var user = person.user || person;
        var text = tooltip && tooltipText ? tooltipText : getName(user);

        return _react2.default.createElement(_avatar2.default, {
            name: text,
            size: size,
            src: user.avatarUrl,
            href: withLink && getLink(user),
            enableTooltip: tooltip
        });
    };

    UserAvatar.defaultProps = {
        size: 'medium',
        tooltip: false,
        withLink: false
    };

    UserAvatar.propTypes = {
        size: _propTypes2.default.oneOf(['xsmall', 'small', 'medium', 'large', 'xlarge', 'xxlarge']),
        person: _propTypes2.default.object.isRequired,
        tooltip: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.bool]),
        withLink: _propTypes2.default.bool
    };

    exports.default = (0, _reactFunctional.pure)(UserAvatar);
    module.exports = exports['default'];
});