define('bitbucket/internal/next/feature/pull-request/pull-request-store', ['exports', 'lodash', 'redux', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/internal/util/entity', 'bitbucket/internal/util/rest-actor', 'bitbucket/internal/util/store/reducers', 'bitbucket/internal/util/store/selectors', 'bitbucket/internal/util/store/store'], function (exports, _lodash, _redux, _reselect, _navbuilder, _entity, _restActor, _reducers, _selectors, _store) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._reducer = exports._actors = exports.selectors = exports.actionCreators = undefined;

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var store = (0, _store2.default)();
    var APP_NAME = 'PULL_REQUEST_CHANGES';

    var getId = function getId(_ref) {
        var pullRequest = _ref.pullRequest;

        return (0, _entity.getPullRequestId)(pullRequest);
    };

    /* ACTIONS */
    var LOAD_UNREVIEWED_COMMITS = 'LOAD_UNREVIEWED_COMMITS';
    var LOAD_UNREVIEWED_COMMITS_SUCCESS = 'LOAD_UNREVIEWED_COMMITS_SUCCESS';
    var LOAD_UNREVIEWED_COMMITS_FAILURE = 'LOAD_UNREVIEWED_COMMITS_FAILURE';

    /* ACTORS */
    var actors = [(0, _restActor.restActorForType)(LOAD_UNREVIEWED_COMMITS, function (action, state) {
        var requestInfo = getRequestInfo(function () {
            return action;
        })(state);

        if ((0, _lodash.get)(requestInfo, 'loading')) {
            return null;
        }

        var pullRequest = action.payload.pullRequest;

        var url = _navbuilder2.default.rest().pullRequest(pullRequest).changes().withParams({
            changeScope: 'unreviewed',
            limit: 1 // Don't load more data then we need
        }).build();

        return { url: url };
    })];

    store.addActors(actors);

    /* REDUCERS */
    var requestKeys = _defineProperty({}, LOAD_UNREVIEWED_COMMITS, []);

    var requestKeyCreator = function requestKeyCreator(_ref2) {
        var type = _ref2.type;
        return requestKeys[type];
    };

    var reducer = (0, _redux.combineReducers)({
        requests: (0, _reducers.getRequestReducer)({
            REQUEST: LOAD_UNREVIEWED_COMMITS,
            REQUEST_SUCCESS: LOAD_UNREVIEWED_COMMITS_SUCCESS,
            REQUEST_FAILURE: LOAD_UNREVIEWED_COMMITS_FAILURE
        })
    });

    store.addReducers(_defineProperty({}, APP_NAME, reducer));

    /* ACTION CREATORS */
    var actionCreators = exports.actionCreators = {
        loadUnreviewedCommits: function loadUnreviewedCommits(_ref3) {
            var pullRequest = _ref3.pullRequest;
            return {
                type: LOAD_UNREVIEWED_COMMITS,
                payload: {
                    pullRequest: pullRequest
                },
                meta: {
                    successType: LOAD_UNREVIEWED_COMMITS_SUCCESS,
                    failureType: LOAD_UNREVIEWED_COMMITS_FAILURE
                }
            };
        }
    };

    /* SELECTORS */

    var _getSelectorsForApp = (0, _selectors.getSelectorsForApp)({
        appName: APP_NAME,
        getId: getId,
        requestKeyCreator: requestKeyCreator
    }),
        getRequestInfo = _getSelectorsForApp.getRequestInfo,
        getLoadingForRequest = _getSelectorsForApp.getLoadingForRequest,
        getResponseForRequest = _getSelectorsForApp.getResponseForRequest;

    var responseSelector = function responseSelector(requestParamsSelector) {
        return getResponseForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadUnreviewedCommits));
    };

    var selectors = exports.selectors = {
        getUnreviewedCommits: function getUnreviewedCommits(requestParamsSelector) {
            return (0, _reselect.createSelector)([responseSelector(requestParamsSelector)], function (response) {
                var commitsCount = (0, _lodash.get)(response, 'properties.unreviewedCommits', 0);
                var includesMerge = (0, _lodash.get)(response, 'properties.includesMerge', false);
                var fromHash = response.fromHash,
                    toHash = response.toHash;


                return {
                    commitsCount: commitsCount,
                    includesMerge: includesMerge,
                    fromHash: fromHash,
                    toHash: toHash
                };
            });
        },

        areUnreviewedCommitsLoading: function areUnreviewedCommitsLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadUnreviewedCommits));
        }
    };

    //Exported for testing only
    exports._actors = actors;
    exports._reducer = reducer;
});