define('bitbucket/internal/next/feature/pull-request/pull-request-reviewers/pull-request-reviewers', ['module', 'exports', 'lodash', 'react', 'react-redux', 'reselect', 'bitbucket/internal/enums', 'bitbucket/internal/util/store/selectors', 'bitbucket/internal/util/store/user', './pull-request-reviewer-status/pull-request-reviewer-status', './pull-request-reviewers-list/pull-request-reviewers-list', './pull-request-reviewers-store', './pull-request-reviewers.less'], function (module, exports, _lodash, _react, _reactRedux, _reselect, _enums, _selectors, _user, _pullRequestReviewerStatus, _pullRequestReviewersList, _pullRequestReviewersStore) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _pullRequestReviewerStatus2 = _interopRequireDefault(_pullRequestReviewerStatus);

    var _pullRequestReviewersList2 = _interopRequireDefault(_pullRequestReviewersList);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var REVIEWERS_MAX_OPEN = 4;

    var PullRequestReviewers = function (_PureComponent) {
        _inherits(PullRequestReviewers, _PureComponent);

        function PullRequestReviewers() {
            _classCallCheck(this, PullRequestReviewers);

            return _possibleConstructorReturn(this, (PullRequestReviewers.__proto__ || Object.getPrototypeOf(PullRequestReviewers)).apply(this, arguments));
        }

        _createClass(PullRequestReviewers, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    currentUser = _props.currentUser,
                    currentUserAsReviewer = _props.currentUserAsReviewer,
                    pullRequest = _props.pullRequest,
                    addSelf = _props.addSelf,
                    removeSelf = _props.removeSelf,
                    setReviewerStatus = _props.setReviewerStatus;

                return _react2.default.createElement(
                    'div',
                    { className: 'pull-request-reviewers' },
                    _react2.default.createElement(_pullRequestReviewersList2.default, {
                        reviewers: pullRequest.reviewers,
                        currentUserAsReviewer: currentUserAsReviewer,
                        permissionToReview: currentUser.slug !== pullRequest.author.user.slug,
                        pullRequestIsOpen: pullRequest.state === _enums.PullRequestState.OPEN,
                        maxOpen: REVIEWERS_MAX_OPEN,
                        addSelf: addSelf,
                        removeSelf: removeSelf,
                        isWatching: true // TODO: https://bulldog.internal.atlassian.com/browse/BBSDEV-18288
                    }),
                    pullRequest.state === _enums.PullRequestState.OPEN && currentUserAsReviewer ? _react2.default.createElement(_pullRequestReviewerStatus2.default, {
                        currentUserAsReviewer: currentUserAsReviewer,
                        onStatusClick: setReviewerStatus,
                        status: (0, _lodash.get)(currentUserAsReviewer, 'status')
                    }) : null
                );
            }
        }]);

        return PullRequestReviewers;
    }(_react.PureComponent);

    //CONNECT
    var mapStateToProps = (0, _reselect.createStructuredSelector)({
        currentUser: _user.selectors.getCurrentUser,
        currentUserAsReviewer: _pullRequestReviewersStore.selectors.getCurrentUserAsReviewer((0, _selectors.singlePropSelector)('pullRequest'))
    });

    var mapDispatchToProps = function mapDispatchToProps(dispatch, _ref) {
        var pullRequest = _ref.pullRequest;
        return {
            addSelf: function addSelf() {
                return dispatch(_pullRequestReviewersStore.actionCreators.addSelfReviewer({ pullRequest: pullRequest }));
            },
            removeSelf: function removeSelf() {
                return dispatch(_pullRequestReviewersStore.actionCreators.removeSelfReviewer({ pullRequest: pullRequest }));
            },
            setReviewerStatus: function setReviewerStatus(status) {
                return dispatch(_pullRequestReviewersStore.actionCreators.setReviewerStatus({ pullRequest: pullRequest, status: status }));
            }
        };
    };

    exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(PullRequestReviewers);
    module.exports = exports['default'];
});