define('bitbucket/internal/next/feature/pull-request/pull-request-reviewers/pull-request-reviewers-store', ['exports', 'icepick', 'lodash', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/internal/enums', 'bitbucket/internal/util/rest-actor', 'bitbucket/internal/util/store/pull-request', 'bitbucket/internal/util/store/store', 'bitbucket/internal/util/store/user'], function (exports, _icepick, _lodash, _reselect, _navbuilder, _server, _enums, _restActor, _pullRequest, _store, _user) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.selectors = exports.actionCreators = undefined;

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var store = (0, _store2.default)();

    /* ACTIONS */
    var ADD_SELF_REVIEWER = 'ADD_SELF_REVIEWER';
    var ADD_SELF_REVIEWER_SUCCESS = 'ADD_SELF_REVIEWER_SUCCESS';
    var ADD_SELF_REVIEWER_FAILURE = 'ADD_SELF_REVIEWER_FAILURE';
    var REMOVE_SELF_REVIEWER = 'REMOVE_SELF_REVIEWER';
    var REMOVE_SELF_REVIEWER_SUCCESS = 'REMOVE_SELF_REVIEWER_SUCCESS';
    var REMOVE_SELF_REVIEWER_FAILURE = 'REMOVE_SELF_REVIEWER_FAILURE';
    var SET_REVIEWER_STATUS = 'SET_REVIEWER_STATUS';
    var SET_REVIEWER_STATUS_SUCCESS = 'SET_REVIEWER_STATUS_SUCCESS';
    var SET_REVIEWER_STATUS_FAILURE = 'SET_REVIEWER_STATUS_FAILURE';

    /* ACTORS */
    var addSelfReviewerActor = (0, _restActor.restActorForType)(ADD_SELF_REVIEWER, function (_ref, state) {
        var payload = _ref.payload;
        var pullRequest = payload.pullRequest;

        var user = _user.selectors.getCurrentUser(state);

        return {
            url: _navbuilder2.default.rest().pullRequest(pullRequest).participants(null).withParams({ avatarSize: _enums.AvatarSize.SMALL }).build(),
            type: _server.method.POST,
            data: { user: user, role: _enums.ParticipantRole.REVIEWER }
        };
    });

    var removeSelfReviewerActor = (0, _restActor.restActorForType)(REMOVE_SELF_REVIEWER, function (_ref2, state) {
        var payload = _ref2.payload;
        var pullRequest = payload.pullRequest;

        var user = _user.selectors.getCurrentUser(state);

        return {
            url: _navbuilder2.default.rest().pullRequest(pullRequest).participants(user).withParams({ avatarSize: _enums.AvatarSize.SMALL }).build(),
            type: _server.method.DELETE,
            data: null
        };
    });

    var setReviewerStatusActor = (0, _restActor.restActorForType)(SET_REVIEWER_STATUS, function (_ref3, state) {
        var payload = _ref3.payload;
        var pullRequest = payload.pullRequest,
            status = payload.status;

        var user = _user.selectors.getCurrentUser(state);

        return {
            url: _navbuilder2.default.rest().pullRequest(pullRequest).participants(user).withParams({ avatarSize: _enums.AvatarSize.SMALL }).build(),
            type: _server.method.PUT,
            data: { status: status }
        };
    });

    var updateReviewersActor = function updateReviewersActor(action, dispatch, state) {
        var addSelf = action.type === ADD_SELF_REVIEWER_SUCCESS;
        var removeSelf = action.type === REMOVE_SELF_REVIEWER_SUCCESS;

        if (!addSelf && !removeSelf) {
            return;
        }

        var originalPayload = (0, _lodash.get)(action, 'meta.originalAction.payload');

        var requestedPullRequest = originalPayload.pullRequest;


        //Get latest version of PR from the store
        var pullRequest = _pullRequest.selectors.getPullRequest(function () {
            return requestedPullRequest;
        })(state);

        var user = _user.selectors.getCurrentUser(state);

        var userAsReviewer = getUserAsReviewer(user, pullRequest);

        if (addSelf) {
            if (userAsReviewer) {
                //PR has already been updated
                return;
            }
            dispatch(_pullRequest.actionCreators.setPullRequest((0, _icepick.setIn)(pullRequest, ['reviewers'], pullRequest.reviewers.concat(action.payload))));
        } else {
            if (!userAsReviewer) {
                //PR has already been updated
                return;
            }
            dispatch(_pullRequest.actionCreators.setPullRequest((0, _icepick.setIn)(pullRequest, ['reviewers'], pullRequest.reviewers.filter(function (reviewer) {
                return reviewer.user.slug !== user.slug;
            }))));
        }
    };

    var updateReviewerStatusActor = function updateReviewerStatusActor(action, dispatch, state) {
        if (action.type !== SET_REVIEWER_STATUS_SUCCESS) {
            return;
        }

        var requestedPullRequest = (0, _lodash.get)(action, 'meta.originalAction.payload.pullRequest');

        //Get latest version of PR from the store
        var pullRequest = _pullRequest.selectors.getPullRequest(function () {
            return requestedPullRequest;
        })(state);

        var updatedReviewer = action.payload;

        var reviewerIndex = pullRequest.reviewers.findIndex(function (reviewer) {
            return reviewer.user.slug === updatedReviewer.user.slug;
        });

        if (reviewerIndex !== -1 && updatedReviewer.status !== pullRequest.reviewers[reviewerIndex].status) {
            dispatch(_pullRequest.actionCreators.setPullRequest((0, _icepick.setIn)(pullRequest, ['reviewers', reviewerIndex], updatedReviewer)));
        }
    };

    var actors = [addSelfReviewerActor, removeSelfReviewerActor, setReviewerStatusActor, updateReviewersActor, updateReviewerStatusActor];

    store.addActors(actors);

    /* ACTION CREATORS */
    var actionCreators = exports.actionCreators = {
        addSelfReviewer: function addSelfReviewer(_ref4) {
            var pullRequest = _ref4.pullRequest;
            return {
                type: ADD_SELF_REVIEWER,
                payload: { pullRequest: pullRequest },
                meta: {
                    successType: ADD_SELF_REVIEWER_SUCCESS,
                    failureType: ADD_SELF_REVIEWER_FAILURE
                }
            };
        },

        removeSelfReviewer: function removeSelfReviewer(_ref5) {
            var pullRequest = _ref5.pullRequest;
            return {
                type: REMOVE_SELF_REVIEWER,
                payload: { pullRequest: pullRequest },
                meta: {
                    successType: REMOVE_SELF_REVIEWER_SUCCESS,
                    failureType: REMOVE_SELF_REVIEWER_FAILURE
                }
            };
        },

        setReviewerStatus: function setReviewerStatus(_ref6) {
            var pullRequest = _ref6.pullRequest,
                status = _ref6.status;
            return {
                type: SET_REVIEWER_STATUS,
                payload: {
                    pullRequest: pullRequest,
                    status: status
                },
                meta: {
                    successType: SET_REVIEWER_STATUS_SUCCESS,
                    failureType: SET_REVIEWER_STATUS_FAILURE
                }
            };
        }
    };

    /* SELECTORS */
    var getUserAsReviewer = function getUserAsReviewer(user, pullRequest) {
        return pullRequest.reviewers.find(function (reviewer) {
            return reviewer.user.slug === user.slug;
        });
    };

    var selectors = exports.selectors = {
        getCurrentUserAsReviewer: function getCurrentUserAsReviewer(pullRequestSelector) {
            return (0, _reselect.createSelector)([_user.selectors.getCurrentUser, pullRequestSelector], getUserAsReviewer);
        }
    };
});