define('bitbucket/internal/next/feature/pull-request/pull-request-reviewers/pull-request-reviewers-list/pull-request-reviewers-list', ['module', 'exports', '@atlaskit/avatar-group', '@atlaskit/icon/glyph/check-circle', '@atlaskit/icon/glyph/presence-busy', '@atlaskit/tooltip', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/enums', 'bitbucket/internal/util/components/react-functional', '../manage-self-as-reviewer-button/manage-self-as-reviewer-button', '../pull-request-current-user-avatar/pull-request-current-user-avatar', '../pull-request-reviewer-avatar/pull-request-reviewer-avatar', '../utils/get-user-display-name', './pull-request-reviewers-list.less'], function (module, exports, _avatarGroup, _checkCircle, _presenceBusy, _tooltip, _aui, _propTypes, _react, _enums, _reactFunctional, _manageSelfAsReviewerButton, _pullRequestCurrentUserAvatar, _pullRequestReviewerAvatar, _getUserDisplayName, _pullRequestReviewersList) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _avatarGroup2 = _interopRequireDefault(_avatarGroup);

    var _checkCircle2 = _interopRequireDefault(_checkCircle);

    var _presenceBusy2 = _interopRequireDefault(_presenceBusy);

    var _tooltip2 = _interopRequireDefault(_tooltip);

    var _react2 = _interopRequireDefault(_react);

    var _manageSelfAsReviewerButton2 = _interopRequireDefault(_manageSelfAsReviewerButton);

    var _pullRequestCurrentUserAvatar2 = _interopRequireDefault(_pullRequestCurrentUserAvatar);

    var _pullRequestReviewerAvatar2 = _interopRequireDefault(_pullRequestReviewerAvatar);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _statusMap;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var approvalOrder = [_enums.ApprovalStatus.APPROVED, _enums.ApprovalStatus.NEEDS_WORK, _enums.ApprovalStatus.UNAPPROVED];

    var statusMap = (_statusMap = {}, _defineProperty(_statusMap, _enums.ApprovalStatus.NEEDS_WORK, _react2.default.createElement(
        'span',
        { className: 'avatar-badge' },
        _react2.default.createElement(_presenceBusy2.default, { size: 'small', primaryColor: _pullRequestReviewersList.needsWorkIconColor })
    )), _defineProperty(_statusMap, _enums.ApprovalStatus.APPROVED, _react2.default.createElement(
        'span',
        { className: 'avatar-badge' },
        _react2.default.createElement(_checkCircle2.default, { size: 'small', primaryColor: _pullRequestReviewersList.approvedPrimaryColor })
    )), _defineProperty(_statusMap, _enums.ApprovalStatus.UNAPPROVED, null), _statusMap);

    var sortReviewers = function sortReviewers(reviewers, currentUserAsReviewer) {
        return reviewers.slice().sort(function (a, b) {
            // sort if is current user
            if (a === currentUserAsReviewer) return -1;
            if (b === currentUserAsReviewer) return 1;
            // sort by status
            if (approvalOrder.indexOf(a.status) < approvalOrder.indexOf(b.status)) return -1;
            if (approvalOrder.indexOf(a.status) > approvalOrder.indexOf(b.status)) return 1;
            // sort by name
            return a.user.displayName.localeCompare(b.user.displayName);
        });
    };

    var PullRequestReviewersList = function PullRequestReviewersList(_ref) {
        var currentUserAsReviewer = _ref.currentUserAsReviewer,
            reviewers = _ref.reviewers,
            permissionToReview = _ref.permissionToReview,
            pullRequestIsOpen = _ref.pullRequestIsOpen,
            addSelf = _ref.addSelf,
            maxOpen = _ref.maxOpen,
            removeSelf = _ref.removeSelf,
            isWatching = _ref.isWatching;

        var showingSelfReviewer = permissionToReview && pullRequestIsOpen;

        var sortedReviewers = sortReviewers(reviewers, currentUserAsReviewer);

        var reviewersData = sortedReviewers.map(function (reviewer) {
            var isCurrentUser = reviewer === currentUserAsReviewer;
            var userName = isCurrentUser ? _aui.I18n.getText('bitbucket.web.pullrequest.self.reviewer.remove') : (0, _getUserDisplayName.getUserDisplayName)(reviewer);

            return {
                name: userName,
                key: reviewer.user.email,
                src: reviewer.user.avatarUrl,
                reviewerStatus: statusMap[reviewer.status],
                component: isCurrentUser ? _pullRequestCurrentUserAvatar2.default : _pullRequestReviewerAvatar2.default,
                enableTooltip: false,
                removeSelf: removeSelf,
                isWatching: isWatching
            };
        });

        return _react2.default.createElement(
            'div',
            { className: 'reverse' },
            _react2.default.createElement(_avatarGroup2.default, { data: reviewersData, appearance: 'grid', maxCount: maxOpen, size: 'small' }),
            !currentUserAsReviewer && showingSelfReviewer ? _react2.default.createElement(
                _tooltip2.default,
                {
                    tag: 'span',
                    content: _aui.I18n.getText('bitbucket.web.pullrequest.self.reviewer.add')
                },
                _react2.default.createElement(_manageSelfAsReviewerButton2.default, { add: true, onClick: addSelf, className: 'add-self' })
            ) : null
        );
    };

    PullRequestReviewersList.propTypes = {
        currentUserAsReviewer: _propTypes.object,
        reviewers: _propTypes.array.isRequired,
        permissionToReview: _propTypes.bool.isRequired,
        pullRequestIsOpen: _propTypes.bool.isRequired,
        addSelf: _propTypes.func.isRequired,
        removeSelf: _propTypes.func.isRequired,
        isWatching: _propTypes.bool.isRequired,
        maxOpen: _propTypes.number.isRequired
    };

    exports.default = (0, _reactFunctional.pure)(PullRequestReviewersList);
    module.exports = exports['default'];
});