define('bitbucket/internal/next/feature/pull-request/pull-request-reviewers/pull-request-current-user-avatar/pull-request-current-user-avatar', ['module', 'exports', '@atlaskit/checkbox', '@atlaskit/inline-dialog', '@atlaskit/tooltip', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/util/components/react-functional', 'bitbucket/internal/util/i18n-html', '../manage-self-as-reviewer-button/manage-self-as-reviewer-button', '../pull-request-reviewer-avatar/pull-request-reviewer-avatar', './pull-request-current-user-avatar.less'], function (module, exports, _checkbox, _inlineDialog, _tooltip, _aui, _propTypes, _react, _reactFunctional, _i18nHtml, _manageSelfAsReviewerButton, _pullRequestReviewerAvatar) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _inlineDialog2 = _interopRequireDefault(_inlineDialog);

    var _tooltip2 = _interopRequireDefault(_tooltip);

    var _react2 = _interopRequireDefault(_react);

    var _i18nHtml2 = _interopRequireDefault(_i18nHtml);

    var _manageSelfAsReviewerButton2 = _interopRequireDefault(_manageSelfAsReviewerButton);

    var _pullRequestReviewerAvatar2 = _interopRequireDefault(_pullRequestReviewerAvatar);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var RemoveSelfDialog = (0, _reactFunctional.pure)(function (_ref) {
        var removeSelf = _ref.removeSelf,
            closeDialog = _ref.closeDialog,
            isWatching = _ref.isWatching;

        var removeSelfReviewer = function removeSelfReviewer() {
            removeSelf();
            closeDialog();
        };

        return _react2.default.createElement(
            'div',
            null,
            _react2.default.createElement(
                'h5',
                null,
                _aui.I18n.getText('bitbucket.web.pullrequest.self.reviewer.remove.confirm.header')
            ),
            _react2.default.createElement(
                'p',
                null,
                _aui.I18n.getText('bitbucket.web.pullrequest.self.reviewer.remove.confirm')
            ),
            isWatching ? _react2.default.createElement(
                'div',
                { className: 'watching-checkbox' },
                _react2.default.createElement(_checkbox.Checkbox, {
                    label: _react2.default.createElement(
                        _i18nHtml2.default,
                        null,
                        _aui.I18n.getText('bitbucket.web.pullrequest.self.reviewer.unwatch.html')
                    )
                })
            ) : null,
            _react2.default.createElement(
                'p',
                null,
                _react2.default.createElement(
                    'button',
                    { className: 'aui-button', onClick: removeSelfReviewer },
                    _aui.I18n.getText('bitbucket.web.pullrequest.self.reviewer.remove.confirm.button')
                )
            )
        );
    });

    var CurrentUserAvatar = function (_Component) {
        _inherits(CurrentUserAvatar, _Component);

        function CurrentUserAvatar() {
            var _ref2;

            var _temp, _this, _ret;

            _classCallCheck(this, CurrentUserAvatar);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref2 = CurrentUserAvatar.__proto__ || Object.getPrototypeOf(CurrentUserAvatar)).call.apply(_ref2, [this].concat(args))), _this), _this.state = { dialogOpen: false }, _this.openDialog = function () {
                _this.setState({ dialogOpen: true });
            }, _this.closeDialog = function () {
                _this.setState({ dialogOpen: false });
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(CurrentUserAvatar, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    name = _props.name,
                    src = _props.src,
                    reviewerStatus = _props.reviewerStatus,
                    removeSelf = _props.removeSelf,
                    isWatching = _props.isWatching;


                return _react2.default.createElement(
                    _inlineDialog2.default,
                    {
                        onClose: this.closeDialog,
                        content: _react2.default.createElement(RemoveSelfDialog, {
                            removeSelf: removeSelf,
                            closeDialog: this.closeDialog,
                            isWatching: isWatching
                        }),
                        isOpen: this.state.dialogOpen,
                        placement: 'bottom'
                    },
                    _react2.default.createElement(
                        _tooltip2.default,
                        { content: name },
                        _react2.default.createElement(
                            'span',
                            { className: 'control-hover-avatar' },
                            _react2.default.createElement(_manageSelfAsReviewerButton2.default, {
                                add: false,
                                onClick: this.openDialog,
                                className: 'remove-self'
                            }),
                            _react2.default.createElement(
                                'span',
                                { className: 'custom-user-avatar' },
                                _react2.default.createElement(_pullRequestReviewerAvatar2.default, {
                                    name: name,
                                    src: src,
                                    reviewerStatus: reviewerStatus,
                                    onClick: this.openDialog,
                                    enableTooltip: false
                                })
                            )
                        )
                    )
                );
            }
        }]);

        return CurrentUserAvatar;
    }(_react.Component);

    CurrentUserAvatar.propTypes = {
        name: _propTypes.string,
        src: _propTypes.string,
        reviewerStatus: _propTypes.node,
        removeSelf: _propTypes.func.isRequired,
        isWatching: _propTypes.bool.isRequired
    };
    exports.default = CurrentUserAvatar;
    module.exports = exports['default'];
});