define('bitbucket/internal/next/feature/pull-request/pull-request-overview/pull-request-overview', ['module', 'exports', '@atlassian/aui', 'react', 'bitbucket/internal/bbui/aui-react/avatar', 'bitbucket/internal/enums', 'bitbucket/internal/util/components/react-functional', 'bitbucket/internal/widget/time', '../pull-request-merge/pull-request-merge-conflict-banner', './pull-request-overview.less'], function (module, exports, _aui, _react, _avatar, _enums, _reactFunctional, _time, _pullRequestMergeConflictBanner) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _time2 = _interopRequireDefault(_time);

    var _pullRequestMergeConflictBanner2 = _interopRequireDefault(_pullRequestMergeConflictBanner);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var PullRequestDescription = (0, _reactFunctional.pure)(function (_ref) {
        var description = _ref.description,
            isHtml = _ref.isHtml;

        if (isHtml) {
            return _react2.default.createElement('div', {
                className: 'description markup',
                dangerouslySetInnerHTML: {
                    __html: description
                }
            });
        } else if (description) {
            return _react2.default.createElement(
                'p',
                { className: 'description' },
                description
            );
        }

        return _react2.default.createElement(
            'p',
            { className: 'description no-description' },
            _aui.I18n.getText('bitbucket.web.pullrequest.no.description'),
            ' ',
            _react2.default.createElement(
                'button',
                { className: 'aui-button aui-button-link' },
                _aui.I18n.getText('bitbucket.web.pullrequest.add.description')
            )
        );
    });

    var PullRequestDetails = (0, _reactFunctional.pure)(function (_ref2) {
        var pullRequest = _ref2.pullRequest;
        return _react2.default.createElement(
            'div',
            { className: 'aui-group pull-request-details' },
            _react2.default.createElement(
                'div',
                { className: 'aui-item' },
                _react2.default.createElement(
                    'h3',
                    null,
                    _aui.I18n.getText('bitbucket.web.pullrequest.details.heading')
                ),
                _react2.default.createElement(
                    'div',
                    { className: 'aui-group details' },
                    _react2.default.createElement(
                        'div',
                        { className: 'aui-item author-avatar-item' },
                        _react2.default.createElement(_avatar.UserAvatar, {
                            className: 'author',
                            person: pullRequest.author,
                            size: _enums.AvatarTShirtSize.MEDIUM
                        })
                    ),
                    _react2.default.createElement(
                        'div',
                        { className: 'aui-item' },
                        _react2.default.createElement(
                            'p',
                            null,
                            //TODO: Not linking the author yet, because it is a huge PITA with react and I18n
                            _aui.I18n.getText('bitbucket.web.pullrequest.summary', pullRequest.author.user.displayName),
                            _react2.default.createElement(_time2.default, {
                                unixTime: pullRequest.createdDate,
                                type: 'shortAge',
                                className: 'creation-date'
                            })
                        ),
                        _react2.default.createElement(PullRequestDescription, {
                            description: pullRequest.descriptionAsHtml || pullRequest.description,
                            isHtml: !!pullRequest.descriptionAsHtml
                        })
                    )
                )
            ),
            _react2.default.createElement(
                'div',
                { className: 'aui-item summary-panel' },
                _react2.default.createElement('div', { className: 'plugin-section-primary' }),
                _react2.default.createElement('div', { className: 'plugin-section-secondary' })
            )
        );
    });

    var PullRequestActivity = function (_PureComponent) {
        _inherits(PullRequestActivity, _PureComponent);

        function PullRequestActivity() {
            _classCallCheck(this, PullRequestActivity);

            return _possibleConstructorReturn(this, (PullRequestActivity.__proto__ || Object.getPrototypeOf(PullRequestActivity)).apply(this, arguments));
        }

        _createClass(PullRequestActivity, [{
            key: 'render',
            value: function render() {
                return _react2.default.createElement(
                    'h3',
                    null,
                    _aui.I18n.getText('bitbucket.web.pullrequest.activity.heading')
                );
            }
        }]);

        return PullRequestActivity;
    }(_react.PureComponent);

    var PullRequestOverview = function (_PureComponent2) {
        _inherits(PullRequestOverview, _PureComponent2);

        function PullRequestOverview() {
            _classCallCheck(this, PullRequestOverview);

            return _possibleConstructorReturn(this, (PullRequestOverview.__proto__ || Object.getPrototypeOf(PullRequestOverview)).apply(this, arguments));
        }

        _createClass(PullRequestOverview, [{
            key: 'render',
            value: function render() {
                var pullRequest = this.props.pullRequest;


                return _react2.default.createElement(
                    'div',
                    { className: 'pull-request-overview' },
                    _react2.default.createElement(_pullRequestMergeConflictBanner2.default, { pullRequest: pullRequest }),
                    _react2.default.createElement(PullRequestDetails, { pullRequest: pullRequest }),
                    _react2.default.createElement(PullRequestActivity, { pullRequest: pullRequest })
                );
            }
        }]);

        return PullRequestOverview;
    }(_react.PureComponent);

    exports.default = PullRequestOverview;
    module.exports = exports['default'];
});