define('bitbucket/internal/next/feature/pull-request/pull-request-merge/pull-request-merge', ['module', 'exports', '@atlaskit/modal-dialog', '@atlassian/aui', 'lodash', 'react', 'react-redux', 'reselect', 'bitbucket/internal/enums', 'bitbucket/internal/util/store/selectors', './merge-button/merge-button', './merge-dialog/merge-dialog', './pull-request-merge-store'], function (module, exports, _modalDialog, _aui, _lodash, _react, _reactRedux, _reselect, _enums, _selectors, _mergeButton, _mergeDialog, _pullRequestMergeStore) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _modalDialog2 = _interopRequireDefault(_modalDialog);

    var _react2 = _interopRequireDefault(_react);

    var _mergeButton2 = _interopRequireDefault(_mergeButton);

    var _mergeDialog2 = _interopRequireDefault(_mergeDialog);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var PullRequestMerge = function (_PureComponent) {
        _inherits(PullRequestMerge, _PureComponent);

        function PullRequestMerge() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, PullRequestMerge);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = PullRequestMerge.__proto__ || Object.getPrototypeOf(PullRequestMerge)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
                mergeDialogIsOpen: false
            }, _this.openMergeDialog = function () {
                return _this.setState({ mergeDialogIsOpen: true });
            }, _this.closeMergeDialog = function () {
                return _this.setState({ mergeDialogIsOpen: false });
            }, _this.mergePullRequest = function () {
                _this.props.mergePullRequest(_this.props.pullRequest);
                _this.closeMergeDialog();
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(PullRequestMerge, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.loadMergeableIfNeeded();
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(prevProps) {
                if (prevProps.pullRequest !== this.props.pullRequest) {
                    this.loadMergeableIfNeeded();
                }
            }
        }, {
            key: 'loadMergeableIfNeeded',
            value: function loadMergeableIfNeeded() {
                var _props = this.props,
                    loadMergeable = _props.loadMergeable,
                    mergeableLoading = _props.mergeableLoading,
                    pullRequest = _props.pullRequest;


                if (pullRequest.state === _enums.PullRequestState.OPEN && !mergeableLoading) {
                    loadMergeable(pullRequest);
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _props2 = this.props,
                    mergeable = _props2.mergeable,
                    mergeableLoading = _props2.mergeableLoading,
                    pullRequest = _props2.pullRequest;

                var canMerge = (0, _lodash.get)(mergeable, 'canMerge');
                var conflicted = (0, _lodash.get)(mergeable, 'conflicted');

                var dialogActions = [{
                    text: _aui.I18n.getText('bitbucket.web.pullrequest.toolbar.merge'),
                    onClick: this.mergePullRequest
                }, {
                    text: _aui.I18n.getText('bitbucket.web.pullrequest.merge.dialog.cancel'),
                    onClick: this.closeMergeDialog
                }];

                return _react2.default.createElement(
                    _react.Fragment,
                    null,
                    pullRequest.state === _enums.PullRequestState.OPEN ? _react2.default.createElement(_mergeButton2.default, {
                        onClick: this.openMergeDialog,
                        disabled: !canMerge || conflicted || mergeableLoading
                    }) : null,
                    _react2.default.createElement(
                        _modalDialog.ModalTransition,
                        null,
                        this.state.mergeDialogIsOpen && _react2.default.createElement(
                            _modalDialog2.default,
                            {
                                onClose: this.closeMergeDialog,
                                heading: _aui.I18n.getText('bitbucket.web.pullrequest.merge.dialog.title'),
                                actions: dialogActions,
                                width: 'large'
                            },
                            _react2.default.createElement(_mergeDialog2.default, { pullRequest: pullRequest })
                        )
                    )
                );
            }
        }]);

        return PullRequestMerge;
    }(_react.PureComponent);

    //CONNECT

    var getPullRequestFromProps = (0, _selectors.singlePropSelector)('pullRequest');

    var mapStateToProps = (0, _reselect.createStructuredSelector)({
        mergeable: _pullRequestMergeStore.selectors.getMergeable(getPullRequestFromProps),
        mergeableLoading: _pullRequestMergeStore.selectors.getMergeableLoading(getPullRequestFromProps)
    });

    var mapDispatchToProps = {
        loadMergeable: _pullRequestMergeStore.actionCreators.loadMergeable,
        mergePullRequest: _pullRequestMergeStore.actionCreators.mergePullRequest
    };

    exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(PullRequestMerge);
    module.exports = exports['default'];
});