define('bitbucket/internal/next/feature/pull-request/pull-request-merge/merge-diagram/merge-diagram', ['module', 'exports', '@atlaskit/button', '@atlaskit/icon/glyph/bitbucket/branches', '@atlaskit/section-message', '@atlaskit/spinner', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/next/images/branch-diagram/branch-diagram-automerge.svg', 'bitbucket/internal/next/images/branch-diagram/branch-diagram-merge.svg', 'bitbucket/internal/next/widget/branch-lozenge/branch-lozenge', './merge-diagram.less'], function (module, exports, _button, _branches, _sectionMessage, _spinner, _aui, _propTypes, _react, _branchDiagramAutomerge, _branchDiagramMerge, _branchLozenge) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _button2 = _interopRequireDefault(_button);

    var _branches2 = _interopRequireDefault(_branches);

    var _sectionMessage2 = _interopRequireDefault(_sectionMessage);

    var _spinner2 = _interopRequireDefault(_spinner);

    var _react2 = _interopRequireDefault(_react);

    var _branchDiagramAutomerge2 = _interopRequireDefault(_branchDiagramAutomerge);

    var _branchDiagramMerge2 = _interopRequireDefault(_branchDiagramMerge);

    var _branchLozenge2 = _interopRequireDefault(_branchLozenge);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var PATH_TOO_LONG = 'PATH_TOO_LONG';
    var INITIAL_PATHS_SHOWN = 3;

    var AutoMergeHelpLink = function AutoMergeHelpLink() {
        return _react2.default.createElement(
            _button2.default,
            {
                spacing: 'none',
                appearance: 'link',
                href: bitbucket_help_url('bitbucket.help.branchmodel.automerge'),
                target: '_blank'
            },
            _aui.I18n.getText('bitbucket.web.pullrequest.automerge.help.link')
        );
    };

    var AutoMergeError = function AutoMergeError(error) {
        switch (error) {
            case PATH_TOO_LONG:
                return _react2.default.createElement(
                    _sectionMessage2.default,
                    { appearance: 'warning' },
                    _aui.I18n.getText('bitbucket.web.pullrequest.automerge.warning.path.too.long')
                );
            //Add other errors here if we decide to display them
            default:
                return null;
        }
    };

    var LozengeWithIcon = function LozengeWithIcon(_ref) {
        var branch = _ref.branch;
        return _react2.default.createElement(_branchLozenge2.default, { branch: branch, icon: _react2.default.createElement(_branches2.default, { size: 'small' }) });
    };

    var MergePaths = function MergePaths(_ref2) {
        var pullRequest = _ref2.pullRequest,
            autoMergePaths = _ref2.autoMergePaths,
            showAllPaths = _ref2.showAllPaths,
            expandPaths = _ref2.expandPaths;

        if (!autoMergePaths) {
            return _react2.default.createElement(
                _react.Fragment,
                null,
                _react2.default.createElement(LozengeWithIcon, { branch: pullRequest.fromRef }),
                _react2.default.createElement(LozengeWithIcon, { branch: pullRequest.toRef })
            );
        }

        if (showAllPaths || autoMergePaths.length <= INITIAL_PATHS_SHOWN) {
            return _react2.default.createElement(
                _react.Fragment,
                null,
                _react2.default.createElement(LozengeWithIcon, { branch: pullRequest.fromRef }),
                autoMergePaths.map(function (branch) {
                    return _react2.default.createElement(LozengeWithIcon, { key: branch.id, branch: branch });
                })
            );
        }

        //Automerge is enabled and there are more than 3 paths in the chain and they are hidden
        return _react2.default.createElement(
            _react.Fragment,
            null,
            _react2.default.createElement(LozengeWithIcon, { branch: pullRequest.fromRef }),
            autoMergePaths.slice(0, INITIAL_PATHS_SHOWN - 1).map(function (branch) {
                return _react2.default.createElement(LozengeWithIcon, { key: branch.id, branch: branch });
            }),
            _react2.default.createElement(
                _button2.default,
                {
                    spacing: 'none',
                    appearance: 'link',
                    onClick: expandPaths,
                    className: 'show-more-branches'
                },
                _aui.I18n.getText('bitbucket.web.pullrequest.automerge.dialog.showmore.button', autoMergePaths.length - INITIAL_PATHS_SHOWN)
            )
        );
    };

    var MergeDiagram = function (_Component) {
        _inherits(MergeDiagram, _Component);

        function MergeDiagram() {
            var _ref3;

            var _temp, _this, _ret;

            _classCallCheck(this, MergeDiagram);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref3 = MergeDiagram.__proto__ || Object.getPrototypeOf(MergeDiagram)).call.apply(_ref3, [this].concat(args))), _this), _this.state = {
                showAllPaths: false
            }, _this.expandPaths = function () {
                _this.setState({ showAllPaths: true });
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(MergeDiagram, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                if (this.props.autoMergeAvailable === undefined) {
                    this.props.loadAutoMerge();
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _props = this.props,
                    pullRequest = _props.pullRequest,
                    autoMergeAvailable = _props.autoMergeAvailable,
                    autoMergeError = _props.autoMergeError,
                    autoMergePaths = _props.autoMergePaths,
                    autoMergeLoading = _props.autoMergeLoading;
                var showAllPaths = this.state.showAllPaths;


                if (autoMergeAvailable === undefined || autoMergeLoading) {
                    return _react2.default.createElement(
                        'div',
                        { className: 'branch-diagram-spinner' },
                        _react2.default.createElement(_spinner2.default, { size: 'large' })
                    );
                }

                return _react2.default.createElement(
                    _react.Fragment,
                    null,
                    _react2.default.createElement(
                        'div',
                        { className: 'branch-diagram' },
                        _react2.default.createElement('img', {
                            alt: 'automerge branch diagram',
                            src: autoMergeAvailable ? _branchDiagramAutomerge2.default : _branchDiagramMerge2.default
                        }),
                        _react2.default.createElement(
                            'div',
                            { className: 'merge-branches' },
                            _react2.default.createElement(MergePaths, {
                                pullRequest: pullRequest,
                                autoMergePaths: autoMergePaths,
                                showAllPaths: showAllPaths,
                                expandPaths: this.expandPaths
                            }),
                            autoMergeAvailable && _react2.default.createElement(AutoMergeHelpLink, null)
                        )
                    ),
                    autoMergeError && _react2.default.createElement(AutoMergeError, { error: autoMergeError })
                );
            }
        }]);

        return MergeDiagram;
    }(_react.Component);

    MergeDiagram.propTypes = {
        pullRequest: _propTypes.object.isRequired,
        autoMergeAvailable: _propTypes.bool,
        autoMergeLoading: _propTypes.bool,
        autoMergeError: _propTypes.string,
        autoMergePaths: (0, _propTypes.arrayOf)(_propTypes.object)
    };

    exports.default = MergeDiagram;
    module.exports = exports['default'];
});