define('bitbucket/internal/next/feature/pull-request/pull-request-merge/merge-diagram/auto-merge-store', ['exports', 'icepick', 'lodash', 'redux', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/internal/util/entity', 'bitbucket/internal/util/rest-actor', 'bitbucket/internal/util/store/reducers', 'bitbucket/internal/util/store/store'], function (exports, _icepick, _lodash, _redux, _reselect, _navbuilder, _server, _entity, _restActor, _reducers, _store) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.selectors = exports.actionCreators = undefined;

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                arr2[i] = arr[i];
            }

            return arr2;
        } else {
            return Array.from(arr);
        }
    }

    var store = (0, _store2.default)();

    var APP_NAME = 'PULL_REQUEST_AUTO_MERGE';

    var LOAD_AUTO_MERGE = 'LOAD_AUTO_MERGE';
    var LOAD_AUTO_MERGE_SUCCESS = 'LOAD_AUTO_MERGE_SUCCESS';
    var LOAD_AUTO_MERGE_FAILURE = 'LOAD_AUTO_MERGE_FAILURE';

    var loadAutoMergeActor = (0, _restActor.restActorForType)(LOAD_AUTO_MERGE, function (_ref) {
        var _nav$rest$project$rep;

        var pullRequest = _ref.payload;
        var _pullRequest$toRef = pullRequest.toRef,
            branchRefId = _pullRequest$toRef.id,
            repository = _pullRequest$toRef.repository;


        return {
            url: (_nav$rest$project$rep = _navbuilder2.default.rest('branch-utils').project(repository.project).repo(repository)).addPathComponents.apply(_nav$rest$project$rep, ['automerge', 'path'].concat(_toConsumableArray(branchRefId.split('/')))).build(),
            type: _server.method.GET
        };
    });

    var actors = [loadAutoMergeActor];

    store.addActors(actors);

    /* REDUCERS */
    var getAutoMergeId = function getAutoMergeId(pullRequest) {
        return (0, _entity.getPullRequestId)(pullRequest) + '/' + pullRequest.toRef.id;
    };

    var reducer = (0, _redux.combineReducers)({
        autoMerge: (0, _reducers.reduceByType)({}, _defineProperty({}, LOAD_AUTO_MERGE_SUCCESS, (0, _reducers.keyBy)(function (action) {
            return getAutoMergeId((0, _reducers.getRequestPayload)(action));
        })(function () {
            var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
            var action = arguments[1];
            return (0, _icepick.merge)(state, action.payload, _reducers.preserveEqualArrays);
        }))),
        requests: (0, _reducers.composeReducers)((0, _reducers.reduceIf)((0, _reducers.actionTypeIn)(LOAD_AUTO_MERGE, LOAD_AUTO_MERGE_FAILURE, LOAD_AUTO_MERGE_SUCCESS)), (0, _reducers.keyBy)(function (action) {
            return getAutoMergeId((0, _reducers.getRequestPayload)(action));
        }), {
            loading: (0, _reducers.toggleReducer)({
                on: [LOAD_AUTO_MERGE],
                off: [LOAD_AUTO_MERGE_SUCCESS, LOAD_AUTO_MERGE_FAILURE]
            })
        })
    });

    store.addReducers(_defineProperty({}, APP_NAME, reducer));

    /* ACTION CREATORS */
    var actionCreators = exports.actionCreators = {
        loadAutoMerge: function loadAutoMerge(pullRequest) {
            return {
                type: LOAD_AUTO_MERGE,
                payload: pullRequest,
                meta: {
                    successType: LOAD_AUTO_MERGE_SUCCESS,
                    failureType: LOAD_AUTO_MERGE_FAILURE
                }
            };
        }
    };

    /* SELECTORS */
    var getAppState = function getAppState(state) {
        return (0, _lodash.get)(state, [APP_NAME]);
    };

    var getAutoMerge = function getAutoMerge(pullRequestSelector) {
        return (0, _reselect.createSelector)([pullRequestSelector, getAppState], function (pullRequest, state) {
            var pullRequestKey = getAutoMergeId(pullRequest);
            return (0, _lodash.get)(state, ['autoMerge', pullRequestKey]);
        });
    };

    var getLoadingForRequest = function getLoadingForRequest(pullRequestSelector) {
        return (0, _reselect.createSelector)([pullRequestSelector, getAppState], function (pullRequest, state) {
            var pullRequestKey = getAutoMergeId(pullRequest);
            return (0, _lodash.get)(state, ['requests', pullRequestKey]);
        });
    };

    var getAutoMergeAvailable = function getAutoMergeAvailable(pullRequestSelector) {
        return (0, _reselect.createSelector)([getAutoMerge(pullRequestSelector)], function (autoMerge) {
            return (0, _lodash.get)(autoMerge, 'status.available');
        });
    };

    var getAutoMergeError = function getAutoMergeError(pullRequestSelector) {
        return (0, _reselect.createSelector)([getAutoMerge(pullRequestSelector), getAutoMergeAvailable(pullRequestSelector)], function (autoMerge, available) {
            return available === false ? autoMerge.status.id : undefined;
        });
    };

    var getAutoMergeLoading = function getAutoMergeLoading(pullRequestSelector) {
        return (0, _reselect.createSelector)([getLoadingForRequest(pullRequestSelector)], function (request) {
            return request ? request.loading : undefined;
        });
    };

    var getAutoMergePaths = function getAutoMergePaths(pullRequestSelector) {
        return (0, _reselect.createSelector)([getAutoMerge(pullRequestSelector), getAutoMergeAvailable(pullRequestSelector)], function (autoMerge, available) {
            return available === true ? autoMerge.path : undefined;
        });
    };

    var selectors = exports.selectors = {
        getAutoMergeAvailable: getAutoMergeAvailable,
        getAutoMergeError: getAutoMergeError,
        getAutoMergeLoading: getAutoMergeLoading,
        getAutoMergePaths: getAutoMergePaths
    };
});