define('bitbucket/internal/next/feature/pull-request/pull-request-lozenge/state-lozenge', ['module', 'exports', '@atlaskit/lozenge', '@atlaskit/tooltip', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/enums', 'bitbucket/internal/util/components/react-functional', 'bitbucket/internal/util/time'], function (module, exports, _lozenge, _tooltip, _aui, _propTypes, _react, _enums, _reactFunctional, _time) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _lozenge2 = _interopRequireDefault(_lozenge);

    var _tooltip2 = _interopRequireDefault(_tooltip);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _customMapping, _pullRequestStateTitl, _lozengeTypeMap;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var propTypes = {
        pullRequest: _propTypes2.default.object.isRequired,
        isBold: _propTypes2.default.bool
    };

    var customMapping = (_customMapping = {}, _defineProperty(_customMapping, _enums.PullRequestState.DECLINED, {
        aMomentAgo: function aMomentAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.a.moment.ago');
        },
        oneMinuteAgo: function oneMinuteAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.one.minute.ago');
        },
        xMinutesAgo: function xMinutesAgo(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.x.minutes.ago', param);
        },
        oneHourAgo: function oneHourAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.one.hour.ago');
        },
        xHoursAgo: function xHoursAgo(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.x.hours.ago', param);
        },
        oneDayAgo: function oneDayAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.one.day.ago');
        },
        xDaysAgo: function xDaysAgo(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.x.days.ago', param);
        },
        oneWeekAgo: function oneWeekAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.one.week.ago');
        },
        absolute: function absolute(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.declined.date.format.absolute', param);
        }
    }), _defineProperty(_customMapping, _enums.PullRequestState.MERGED, {
        aMomentAgo: function aMomentAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.a.moment.ago');
        },
        oneMinuteAgo: function oneMinuteAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.one.minute.ago');
        },
        xMinutesAgo: function xMinutesAgo(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.x.minutes.ago', param);
        },
        oneHourAgo: function oneHourAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.one.hour.ago');
        },
        xHoursAgo: function xHoursAgo(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.x.hours.ago', param);
        },
        oneDayAgo: function oneDayAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.one.day.ago');
        },
        xDaysAgo: function xDaysAgo(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.x.days.ago', param);
        },
        oneWeekAgo: function oneWeekAgo() {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.one.week.ago');
        },
        absolute: function absolute(param) {
            return _aui.I18n.getText('bitbucket.web.pullrequest.merged.date.format.absolute', param);
        }
    }), _customMapping);

    var pullRequestStateTitleMap = (_pullRequestStateTitl = {}, _defineProperty(_pullRequestStateTitl, _enums.PullRequestState.OPEN, _aui.I18n.getText('bitbucket.web.pullrequest.state.open')), _defineProperty(_pullRequestStateTitl, _enums.PullRequestState.DECLINED, _aui.I18n.getText('bitbucket.web.pullrequest.state.declined')), _defineProperty(_pullRequestStateTitl, _enums.PullRequestState.MERGED, _aui.I18n.getText('bitbucket.web.pullrequest.state.merged')), _pullRequestStateTitl);

    var lozengeTypeMap = (_lozengeTypeMap = {}, _defineProperty(_lozengeTypeMap, _enums.PullRequestState.OPEN, 'inprogress'), _defineProperty(_lozengeTypeMap, _enums.PullRequestState.MERGED, 'success'), _defineProperty(_lozengeTypeMap, _enums.PullRequestState.DECLINED, 'removed'), _lozengeTypeMap);

    var StateLozenge = function StateLozenge(_ref) {
        var pullRequest = _ref.pullRequest,
            _ref$isBold = _ref.isBold,
            isBold = _ref$isBold === undefined ? true : _ref$isBold;

        var stateLozenge = _react2.default.createElement(
            _lozenge2.default,
            { isBold: isBold, appearance: lozengeTypeMap[pullRequest.state] },
            pullRequestStateTitleMap[pullRequest.state]
        );

        if (pullRequest.state === _enums.PullRequestState.OPEN) {
            return stateLozenge;
        }

        return _react2.default.createElement(
            _tooltip2.default,
            {
                tag: 'span',
                content: (0, _time.format)(pullRequest.closedDate, 'shortAge', customMapping[pullRequest.state])
            },
            stateLozenge
        );
    };

    StateLozenge.propTypes = propTypes;

    exports.default = (0, _reactFunctional.pure)(StateLozenge);
    module.exports = exports['default'];
});