define('bitbucket/internal/next/feature/pull-request/pull-request-header/pull-request-header', ['module', 'exports', '@atlassian/aui', 'classnames', 'lodash', 'react', 'bitbucket/internal/enums', 'bitbucket/internal/next/feature/pull-request/pull-request-lozenge/state-lozenge', 'bitbucket/internal/next/widget/avatar/user-avatar', 'bitbucket/internal/next/widget/branch-from-to/branch-from-to', 'bitbucket/internal/util/components/react-functional', '../pull-request-merge/pull-request-merge', '../pull-request-reviewers/pull-request-reviewers', './pull-request-header.less'], function (module, exports, _aui, _classnames, _lodash, _react, _enums, _stateLozenge, _userAvatar, _branchFromTo, _reactFunctional, _pullRequestMerge, _pullRequestReviewers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _react2 = _interopRequireDefault(_react);

    var _stateLozenge2 = _interopRequireDefault(_stateLozenge);

    var _userAvatar2 = _interopRequireDefault(_userAvatar);

    var _branchFromTo2 = _interopRequireDefault(_branchFromTo);

    var _pullRequestMerge2 = _interopRequireDefault(_pullRequestMerge);

    var _pullRequestReviewers2 = _interopRequireDefault(_pullRequestReviewers);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    exports.default = (0, _reactFunctional.pure)(function (_ref) {
        var pullRequest = _ref.pullRequest;
        return _react2.default.createElement(
            'header',
            { className: 'pull-request-header' },
            _react2.default.createElement(
                'div',
                { className: 'flexible' },
                _react2.default.createElement(
                    'div',
                    { className: 'pull-request-metadata' },
                    _react2.default.createElement(_userAvatar2.default, { person: pullRequest.author.user, tooltip: true }),
                    _react2.default.createElement(_branchFromTo2.default, { fromRef: pullRequest.fromRef, toRef: pullRequest.toRef }),
                    _react2.default.createElement(_stateLozenge2.default, { pullRequest: pullRequest })
                ),
                _react2.default.createElement(
                    'div',
                    {
                        className: (0, _classnames2.default)('pull-request-actions', {
                            'pull-request-is-open': pullRequest.state === _enums.PullRequestState.OPEN
                        })
                    },
                    _react2.default.createElement(_pullRequestReviewers2.default, { pullRequest: pullRequest }),
                    _react2.default.createElement(_pullRequestMerge2.default, { pullRequest: pullRequest })
                )
            ),
            _react2.default.createElement(
                'h2',
                null,
                pullRequest.title
            )
        );
    });
    module.exports = exports['default'];
});