define('bitbucket/internal/next/feature/pull-request/pull-request-commits/pull-request-commits', ['module', 'exports', '@atlassian/aui', 'lodash', 'react', 'react-redux', 'react-router-dom', 'reselect', 'bitbucket/util/navbuilder', 'bitbucket/internal/bbui/aui-react/avatar', 'bitbucket/internal/bbui/paged-table/paged-table', 'bitbucket/internal/util/components/react-functional', 'bitbucket/internal/util/parse-commit-message', 'bitbucket/internal/util/store/commit', 'bitbucket/internal/util/store/selectors', 'bitbucket/internal/widget/time', './pull-request-commits.less'], function (module, exports, _aui, _lodash, _react, _reactRedux, _reactRouterDom, _reselect, _navbuilder, _avatar, _pagedTable, _reactFunctional, _parseCommitMessage, _commit, _selectors, _time) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _react2 = _interopRequireDefault(_react);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _pagedTable2 = _interopRequireDefault(_pagedTable);

    var _parseCommitMessage2 = _interopRequireDefault(_parseCommitMessage);

    var _time2 = _interopRequireDefault(_time);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var PullRequestCommitRow = (0, _reactFunctional.pure)(function (_ref) {
        var pullRequest = _ref.pullRequest,
            commit = _ref.commit;

        var message = _parseCommitMessage2.default.splitIntoSubjectAndBody(commit.message);
        var commitUrl = _navbuilder2.default.pullRequest(pullRequest).commit(commit.id).build();

        return _react2.default.createElement(
            'tr',
            null,
            _react2.default.createElement(
                'td',
                { className: 'author' },
                _react2.default.createElement(_avatar.UserAvatar, {
                    person: commit.author,
                    withName: true,
                    withLink: true,
                    linkClassName: 'secondary-link'
                })
            ),
            _react2.default.createElement(
                'td',
                { className: 'commit' },
                _react2.default.createElement(
                    _reactRouterDom.Link,
                    { to: commitUrl, className: 'commit-link' },
                    commit.displayId
                )
            ),
            _react2.default.createElement(
                'td',
                { className: 'message' },
                _react2.default.createElement(
                    'span',
                    { className: 'message-subject', title: commit.message },
                    _react2.default.createElement(
                        _reactRouterDom.Link,
                        { to: commitUrl, className: 'commit-link' },
                        message.subject
                    )
                ),
                _react2.default.createElement(
                    'span',
                    { className: 'message-body', title: commit.message },
                    _react2.default.createElement(
                        _reactRouterDom.Link,
                        { to: commitUrl, className: 'commit-link' },
                        message.body
                    )
                )
            ),
            _react2.default.createElement('td', { className: 'comment-count' }),
            _react2.default.createElement(
                'td',
                { className: 'timestamp' },
                _react2.default.createElement(_time2.default, { unixTime: commit.authorTimestamp, type: 'shortAge' })
            )
        );
    });

    var CommitTableHeader = (0, _lodash.once)(function () {
        return _react2.default.createElement(
            'tr',
            null,
            _react2.default.createElement(
                'th',
                {
                    className: 'author',
                    title: _aui.I18n.getText('bitbucket.web.repository.commits.col.author'),
                    scope: 'col'
                },
                _aui.I18n.getText('bitbucket.web.repository.commits.col.author')
            ),
            _react2.default.createElement(
                'th',
                {
                    className: 'commit',
                    title: _aui.I18n.getText('bitbucket.web.repository.commits.col.commit'),
                    scope: 'col'
                },
                _aui.I18n.getText('bitbucket.web.repository.commits.col.commit')
            ),
            _react2.default.createElement(
                'th',
                {
                    className: 'message',
                    title: _aui.I18n.getText('bitbucket.web.repository.commits.col.message'),
                    scope: 'col'
                },
                _aui.I18n.getText('bitbucket.web.repository.commits.col.message')
            ),
            _react2.default.createElement('th', { className: 'comment-count', scope: 'col' }),
            _react2.default.createElement(
                'th',
                {
                    className: 'timestamp',
                    title: _aui.I18n.getText('bitbucket.web.repository.commits.col.date'),
                    scope: 'col'
                },
                _aui.I18n.getText('bitbucket.web.repository.commits.col.date')
            )
        );
    });

    var PullRequestCommits = (0, _reactFunctional.pure)(function (_ref2) {
        var loadCommits = _ref2.loadCommits,
            loading = _ref2.loading,
            commits = _ref2.commits,
            allFetched = _ref2.allFetched,
            pullRequest = _ref2.pullRequest;
        return _react2.default.createElement(_pagedTable2.default, {
            loading: loading,
            items: commits,
            allFetched: allFetched,
            className: 'commits-table',
            onMoreItemsRequested: function onMoreItemsRequested() {
                return loadCommits({
                    pullRequest: pullRequest
                });
            },
            header: CommitTableHeader,
            row: function row(_ref3) {
                var commit = _ref3.item;
                return _react2.default.createElement(PullRequestCommitRow, { key: commit.id, pullRequest: pullRequest, commit: commit });
            }
        });
    });

    //CONNECT

    var requestParamsFromProps = (0, _selectors.filteredPropsSelector)(['pullRequest']);

    var mapStateToProps = (0, _reselect.createStructuredSelector)({
        commits: _commit.selectors.getPullRequestCommits(requestParamsFromProps),
        loading: _commit.selectors.getPullRequestCommitsLoading(requestParamsFromProps),
        allFetched: _commit.selectors.getPullRequestCommitsAllFetched(requestParamsFromProps)
    });

    var mapDispatchToProps = {
        loadCommits: _commit.actionCreators.loadPullRequestCommits
    };

    exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(PullRequestCommits);
    module.exports = exports['default'];
});