define('bitbucket/internal/next/feature/diff/diff-utils', ['exports', 'lodash', 'bitbucket/internal/enums'], function (exports, _lodash, _enums) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.getMatchingDiff = exports.getDiffChangeMatcher = exports.getMaxLineNumber = undefined;
    var getMaxLineNumber = exports.getMaxLineNumber = function getMaxLineNumber(diff) {
        var lastHunk = (0, _lodash.last)(diff.hunks);

        return lastHunk && Math.max(lastHunk.sourceLine + lastHunk.sourceSpan, lastHunk.destinationLine + lastHunk.destinationSpan);
    };

    var getDiffChangeMatcher = exports.getDiffChangeMatcher = function getDiffChangeMatcher(change) {
        return function (diff) {
            /**
             * Change
             *      add/delete/modify: `path` only
             *      move/copy/rename: `srcPath` & `path` present and different
             *
             * Diff
             *      add: `destination` only
             *      delete: `source` only
             *      modify: `source` & `destination` present and the same
             *      move/copy/rename: `source` & `destination` present and different
             */
            switch (change.type) {
                case _enums.ChangeTypes.ADD:
                    return diff.destination === change.path && !diff.source;
                case _enums.ChangeTypes.DELETE:
                    return diff.source === change.path && !diff.destination;
                case _enums.ChangeTypes.MODIFY:
                    return diff.destination === change.path && diff.source === change.path;
                case _enums.ChangeTypes.MOVE:
                case _enums.ChangeTypes.COPY:
                case _enums.ChangeTypes.RENAME:
                    return diff.destination === change.path && diff.source === change.srcPath;
                default:
                    return false;
            }
        };
    };

    var getMatchingDiff = exports.getMatchingDiff = function getMatchingDiff(_ref) {
        var change = _ref.change,
            diffs = _ref.diffs;

        if (diffs.length <= 1) {
            return diffs[0];
        }

        return diffs.find(getDiffChangeMatcher(change)) || diffs[0];
    };
});