define('bitbucket/internal/next/feature/changes/changes-tree/utils/normalize-files', ['module', 'exports', 'lodash', 'bitbucket/internal/model/content-tree-node-types', 'bitbucket/internal/widget/tree-view/enums'], function (module, exports, _lodash, _contentTreeNodeTypes, _enums) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _contentTreeNodeTypes2 = _interopRequireDefault(_contentTreeNodeTypes);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var normalizeFiles = function normalizeFiles(files) {
        return files.map(function (_ref) {
            var changeType = _ref.type,
                hasConflict = _ref.conflict,
                type = _ref.nodeType,
                path = _ref.path,
                srcPath = _ref.srcPath,
                commentsCount = _ref.properties.activeComments;

            var pathComponents = path.split(_enums.PATH_SEPARATOR);

            return {
                id: path,
                changeType: changeType,
                type: type,
                isSubmodule: type === _contentTreeNodeTypes2.default.SUBMODULE,
                hasConflict: Boolean(hasConflict),
                hasComments: Boolean(commentsCount),
                path: pathComponents,
                srcPath: srcPath,
                name: (0, _lodash.last)(pathComponents)
            };
        });
    };

    exports.default = normalizeFiles;
    module.exports = exports['default'];
});