define('bitbucket/internal/next/feature/changes/changes-tree/file/file', ['module', 'exports', 'classnames', 'prop-types', 'react', 'bitbucket/internal/enums', 'bitbucket/internal/next/widget/tooltip/long-tooltip', 'bitbucket/internal/util/dom-event', 'bitbucket/internal/widget/icons/icons', '../utils/file-change-status', './file.less'], function (module, exports, _classnames, _propTypes, _react, _enums, _longTooltip, _domEvent, _icons, _fileChangeStatus) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _longTooltip2 = _interopRequireDefault(_longTooltip);

    var _domEvent2 = _interopRequireDefault(_domEvent);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var _changeTypeIconsMap;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var changeTypeIconsMap = (_changeTypeIconsMap = {}, _defineProperty(_changeTypeIconsMap, _enums.ChangeTypes.ADD, _icons.FileAddedIcon), _defineProperty(_changeTypeIconsMap, _enums.ChangeTypes.COPY, _icons.FileCopiedIcon), _defineProperty(_changeTypeIconsMap, _enums.ChangeTypes.DELETE, _icons.FileRemovedIcon), _defineProperty(_changeTypeIconsMap, _enums.ChangeTypes.MODIFY, _icons.FileModifiedIcon), _defineProperty(_changeTypeIconsMap, _enums.ChangeTypes.MOVE, _icons.FileMovedIcon), _defineProperty(_changeTypeIconsMap, _enums.ChangeTypes.RENAME, _icons.FileRenamedIcon), _changeTypeIconsMap);

    var changeTypesValues = Object.values(_enums.ChangeTypes);

    var renderFileStatusIcon = function renderFileStatusIcon(Icon) {
        return _react2.default.createElement(Icon, { className: 'status-icon' });
    };

    var File = function (_Component) {
        _inherits(File, _Component);

        function File(props) {
            _classCallCheck(this, File);

            var _this = _possibleConstructorReturn(this, (File.__proto__ || Object.getPrototypeOf(File)).call(this, props));

            _this.selectFile = function (event) {
                if (!_domEvent2.default.openInSameTab(event)) {
                    return;
                }

                var _this$props = _this.props,
                    isSelected = _this$props.isSelected,
                    id = _this$props.id,
                    selectFile = _this$props.selectFile;


                if (isSelected) {
                    return;
                }

                selectFile(id);
            };

            _this.elementRef = _react2.default.createRef();
            return _this;
        }

        _createClass(File, [{
            key: 'shouldComponentUpdate',
            value: function shouldComponentUpdate(newProps) {
                return this.props.isSelected !== newProps.isSelected;
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(prevProp) {
                var wasSelected = !prevProp.isSelected && this.props.isSelected;
                var element = this.elementRef.current;

                if (wasSelected) {
                    element.focus();
                    element.click();
                }
            }
        }, {
            key: 'getStatusIcon',
            value: function getStatusIcon() {
                var _props = this.props,
                    hasConflict = _props.hasConflict,
                    isSubmodule = _props.isSubmodule,
                    changeType = _props.changeType;


                var IconComponent = _icons.FileUnknownIcon;

                if (hasConflict) {
                    IconComponent = _icons.FileConflictedIcon;
                } else if (isSubmodule) {
                    IconComponent = _icons.SubmoduleIcon;
                } else if (changeTypeIconsMap.hasOwnProperty(changeType)) {
                    IconComponent = changeTypeIconsMap[changeType];
                }

                return renderFileStatusIcon(IconComponent);
            }
        }, {
            key: 'render',
            value: function render() {
                var _props2 = this.props,
                    id = _props2.id,
                    name = _props2.name,
                    isSelected = _props2.isSelected,
                    changeType = _props2.changeType,
                    hasConflict = _props2.hasConflict;

                var fileUrl = '#' + id;

                var className = (0, _classnames2.default)('file', {
                    'file-selected': isSelected,
                    'file-with-conflict': hasConflict
                });

                var fileStatusIcon = this.getStatusIcon();
                var tooltipText = (0, _fileChangeStatus.getFileChangeStatus)({
                    filename: name,
                    changeType: changeType,
                    hasConflict: hasConflict
                });

                return _react2.default.createElement(
                    'li',
                    { className: className },
                    _react2.default.createElement(
                        'a',
                        { href: fileUrl, onClick: this.selectFile, ref: this.elementRef },
                        _react2.default.createElement(
                            _longTooltip2.default,
                            { content: tooltipText },
                            _react2.default.createElement(
                                'span',
                                { className: 'file-label' },
                                fileStatusIcon,
                                name
                            )
                        )
                    )
                );
            }
        }]);

        return File;
    }(_react.Component);

    File.propTypes = {
        name: _propTypes2.default.node.isRequired,
        selectFile: _propTypes2.default.func.isRequired,
        isSelected: _propTypes2.default.bool,
        id: _propTypes2.default.string.isRequired,
        changeType: _propTypes2.default.oneOf(changeTypesValues).isRequired,
        hasConflict: _propTypes2.default.bool,
        isSubmodule: _propTypes2.default.bool
    };
    File.defaultProps = {
        isSelected: false,
        hasConflict: false,
        isSubmodule: false
    };
    exports.default = File;
    module.exports = exports['default'];
});