define('bitbucket/internal/next/feature/changes/changes-tree/connected-changes-tree', ['module', 'exports', 'react-redux', 'react-router-dom', 'reselect', 'bitbucket/internal/util/components/react-functional', 'bitbucket/internal/util/components/with-keyboard-list-selector', './changes-tree', './changes-tree-store'], function (module, exports, _reactRedux, _reactRouterDom, _reselect, _reactFunctional, _withKeyboardListSelector, _changesTree, _changesTreeStore) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _withKeyboardListSelector2 = _interopRequireDefault(_withKeyboardListSelector);

    var _changesTree2 = _interopRequireDefault(_changesTree);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var selectNextItem = _changesTreeStore.actionCreators.selectNextItem,
        selectPrevItem = _changesTreeStore.actionCreators.selectPrevItem,
        updateList = _changesTreeStore.actionCreators.updateList,
        updateParentsMap = _changesTreeStore.actionCreators.updateParentsMap;


    var mapStateTopProps = (0, _reselect.createStructuredSelector)({
        files: _changesTreeStore.selectors.getFiles,
        tree: _changesTreeStore.selectors.getTree,
        parents: _changesTreeStore.selectors.getTreeParents
    });

    var mapDispatchToProps = {
        selectNextItem: selectNextItem,
        selectPrevItem: selectPrevItem,
        updateList: updateList,
        updateParentsMap: updateParentsMap
    };

    function syncChangesTreeStateOnChange() {
        var _props = this.props,
            updateList = _props.updateList,
            updateParentsMap = _props.updateParentsMap,
            parents = _props.parents,
            files = _props.files,
            selectedFile = _props.selectedFile,
            history = _props.history,
            location = _props.location;


        updateList({
            list: files,
            selectedId: selectedFile
        });

        updateParentsMap({ parents: parents });

        if (!selectedFile && files.length) {
            var firstFilePath = files[0].id;

            history.replace({
                search: location.search,
                hash: firstFilePath
            });
        }
    }

    var enhance = (0, _reactFunctional.compose)(_reactRouterDom.withRouter, (0, _reactRedux.connect)(mapStateTopProps, mapDispatchToProps), (0, _reactFunctional.withLifecycle)({
        componentDidMount: syncChangesTreeStateOnChange,
        componentDidUpdate: syncChangesTreeStateOnChange
    }), (0, _withKeyboardListSelector2.default)());

    exports.default = enhance(_changesTree2.default);
    module.exports = exports['default'];
});