define('bitbucket/internal/next/feature/changes/changes-tree/changes-tree-store', ['exports', 'lodash', 'reselect', 'bitbucket/internal/next/feature/changes/changes-tree/utils/paths-sorting-comparators', 'bitbucket/internal/util/store/reducers', 'bitbucket/internal/util/store/selectors', 'bitbucket/internal/widget/tree-view/tree-builder', './utils/normalize-files'], function (exports, _lodash, _reselect, _pathsSortingComparators, _reducers, _selectors, _treeBuilder, _normalizeFiles) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.selectors = exports.actionCreators = exports._CONSTANTS = exports.stateNamespace = undefined;
    exports.reducer = reducer;

    var _normalizeFiles2 = _interopRequireDefault(_normalizeFiles);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _reduceByType2;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    // Constants
    var SELECT_NEXT_ITEM = 'SELECT_NEXT_ITEM';
    var SELECT_PREV_ITEM = 'SELECT_PREV_ITEM';
    var SELECT_ITEM = 'SELECT_ITEM';

    var UPDATE_LIST = 'UPDATE_LIST';
    var UPDATE_PARENTS_MAP = 'UPDATE_PARENTS_MAP ';
    var TOGGLE_COLLAPSE = 'TOGGLE_COLLAPSE';

    var STATE_NAMESPACE = 'changesTree';

    var NODE_EXPANDED = false;
    var NODE_COLLAPSED = true;

    exports.stateNamespace = STATE_NAMESPACE;


    /** @visibleForTesting */
    var _CONSTANTS = exports._CONSTANTS = {
        SELECT_NEXT_ITEM: SELECT_NEXT_ITEM,
        SELECT_PREV_ITEM: SELECT_PREV_ITEM,
        SELECT_ITEM: SELECT_ITEM,
        UPDATE_LIST: UPDATE_LIST,
        UPDATE_PARENTS_MAP: UPDATE_PARENTS_MAP,
        TOGGLE_COLLAPSE: TOGGLE_COLLAPSE,
        NODE_COLLAPSED: NODE_COLLAPSED,
        NODE_EXPANDED: NODE_EXPANDED
    };

    /* ACTION CREATORS */
    var actionCreators = exports.actionCreators = {
        updateList: function updateList(_ref) {
            var list = _ref.list,
                _ref$selectedId = _ref.selectedId,
                selectedId = _ref$selectedId === undefined ? null : _ref$selectedId;
            return {
                type: UPDATE_LIST,
                list: list,
                selectedId: selectedId
            };
        },

        updateParentsMap: function updateParentsMap(_ref2) {
            var parents = _ref2.parents;
            return {
                type: UPDATE_PARENTS_MAP,
                parents: parents
            };
        },

        selectNextItem: function selectNextItem() {
            return {
                type: SELECT_NEXT_ITEM
            };
        },

        selectPrevItem: function selectPrevItem() {
            return {
                type: SELECT_PREV_ITEM
            };
        },

        selectItem: function selectItem(selectedId) {
            return {
                type: SELECT_ITEM,
                selectedId: selectedId
            };
        },

        toggleCollapse: function toggleCollapse(nodeId) {
            return {
                type: TOGGLE_COLLAPSE,
                nodeId: nodeId
            };
        }
    };

    /* SELECTORS */
    var getChangesTree = function getChangesTree(state) {
        return state[STATE_NAMESPACE];
    };

    var getNodeId = (0, _selectors.singlePropSelector)('id');

    var getSelectedNode = (0, _reselect.createSelector)([getChangesTree], function (_ref3) {
        var list = _ref3.list,
            selectedIndex = _ref3.selectedIndex;
        return list[selectedIndex];
    });

    var getNormalizedFiles = (0, _selectors.filteredPropsSelector)(['files'], _normalizeFiles2.default);

    var getFiles = (0, _reselect.createSelector)([getNormalizedFiles], function (files) {
        return files.sort(function (_ref4, _ref5) {
            var pathA = _ref4.id;
            var pathB = _ref5.id;
            return (0, _pathsSortingComparators.filePathsComparator)(pathA, pathB);
        });
    });

    var getTree = (0, _reselect.createSelector)([getNormalizedFiles], function (files) {
        return (0, _treeBuilder.buildTree)(files, _pathsSortingComparators.branchPathsComparator);
    });

    var selectors = exports.selectors = {
        getFiles: getFiles,
        getTree: getTree,

        isNodeCollapsed: (0, _reselect.createSelector)([getChangesTree, getNodeId], function (_ref6, nodeId) {
            var collapsed = _ref6.collapsed;
            return collapsed[nodeId] === NODE_COLLAPSED;
        }),

        isNodeSelected: (0, _reselect.createSelector)([getSelectedNode, getNodeId], function (selectedNode, id) {
            return selectedNode && selectedNode.id === id;
        }),

        getTreeParents: (0, _reselect.createSelector)([getTree], _treeBuilder.buildNodesRelation)
    };

    /* REDUCERS */
    /**
     * Select the item with the given ID. If the item isn't in the list, select the first item in the list.
     * @param {Array<{ id: * }>} list
     * @param {*} selectedId
     * @returns {number}
     */
    var selectById = function selectById(list, selectedId) {
        return Math.max(0, list.findIndex(function (_ref7) {
            var id = _ref7.id;
            return selectedId === id;
        }));
    };

    var getNodePath = function getNodePath(parents, nodeId) {
        var path = [];
        var currentNodeId = nodeId;

        while (parents.hasOwnProperty(currentNodeId)) {
            path.unshift(currentNodeId);

            currentNodeId = parents[currentNodeId];
        }

        return path;
    };

    var ensureNodePathIsExpanded = function ensureNodePathIsExpanded(collapsedState, parents, node) {
        var anyExpanded = false;
        var newCollapsedState = _extends({}, collapsedState);

        var path = node ? getNodePath(parents, node.id) : [];
        path.forEach(function (id) {
            if (collapsedState[id] !== NODE_EXPANDED) {
                anyExpanded = true;
                newCollapsedState[id] = NODE_EXPANDED;
            }
        });

        return anyExpanded ? newCollapsedState : collapsedState;
    };

    var reduceByNodeId = (0, _reducers.keyBy)(function (_ref8) {
        var nodeId = _ref8.nodeId;
        return nodeId || null;
    });

    var listReducer = (0, _reducers.reduceByType)([], _defineProperty({}, UPDATE_LIST, function (prevList, _ref9) {
        var list = _ref9.list;
        return list;
    }));

    var selectedIndexReducer = (0, _reducers.reduceByType)(0, (_reduceByType2 = {}, _defineProperty(_reduceByType2, UPDATE_LIST, function (i, _ref10) {
        var list = _ref10.list,
            _ref10$selectedId = _ref10.selectedId,
            selectedId = _ref10$selectedId === undefined ? null : _ref10$selectedId;
        return selectedId ? selectById(list, selectedId) : 0;
    }), _defineProperty(_reduceByType2, SELECT_NEXT_ITEM, function (i, action, list) {
        return (0, _lodash.clamp)(i + 1, 0, list.length - 1);
    }), _defineProperty(_reduceByType2, SELECT_PREV_ITEM, function (i, action, list) {
        return (0, _lodash.clamp)(i - 1, 0, list.length - 1);
    }), _defineProperty(_reduceByType2, SELECT_ITEM, function (i, _ref11, list) {
        var selectedId = _ref11.selectedId;
        return selectById(list, selectedId);
    }), _reduceByType2));

    var parentsReducer = (0, _reducers.reduceByType)({}, _defineProperty({}, UPDATE_PARENTS_MAP, function (state, _ref12) {
        var parents = _ref12.parents;
        return parents;
    }));

    var collapsedReducer = (0, _reducers.reduceByTypes)({}, [[TOGGLE_COLLAPSE, reduceByNodeId(function () {
        var collapsedState = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : NODE_EXPANDED;
        return collapsedState === NODE_EXPANDED ? NODE_COLLAPSED : NODE_EXPANDED;
    })], [[SELECT_ITEM, SELECT_NEXT_ITEM, SELECT_PREV_ITEM], function (state, action, _ref13) {
        var parents = _ref13.parents,
            list = _ref13.list,
            selectedIndex = _ref13.selectedIndex;
        return ensureNodePathIsExpanded(state, parents, list[selectedIndex]);
    }]]);

    function reducer() {
        var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
        var action = arguments[1];

        var list = listReducer(state.list, action);
        var selectedIndex = selectedIndexReducer(state.selectedIndex, action, list);
        var parents = parentsReducer(state.parents, action);
        var collapsed = collapsedReducer(state.collapsed, action, { parents: parents, list: list, selectedIndex: selectedIndex });

        return (0, _reducers.preserveIfEquivalent)(state, {
            list: list,
            selectedIndex: selectedIndex,
            parents: parents,
            collapsed: collapsed
        });
    }
});