define('bitbucket/internal/next/feature/changes/changes-scope-selector/changes-scope-selector', ['module', 'exports', '@atlaskit/select', 'prop-types', 'react', 'bitbucket/util/navbuilder', 'bitbucket/internal/next/util/react-i18n', './changes-scope-selector.less', './commit-option', './commit-range-value', './commit-single-value'], function (module, exports, _select, _propTypes, _react, _navbuilder, _reactI18n, _changesScopeSelector, _commitOption, _commitRangeValue, _commitSingleValue) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _select2 = _interopRequireDefault(_select);

    var _react2 = _interopRequireDefault(_react);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _commitOption2 = _interopRequireDefault(_commitOption);

    var _commitRangeValue2 = _interopRequireDefault(_commitRangeValue);

    var _commitSingleValue2 = _interopRequireDefault(_commitSingleValue);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                arr2[i] = arr[i];
            }

            return arr2;
        } else {
            return Array.from(arr);
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var commitMenuStyles = function commitMenuStyles(base) {
        return _extends({}, base, {
            width: _changesScopeSelector.changesScopeSelectorMenuWidth
        });
    };

    var controlStyles = function controlStyles(base) {
        return _extends({}, base, {
            minHeight: _changesScopeSelector.changesScopeSelectorHeight
        });
    };

    var getPullRequestUrl = function getPullRequestUrl(pullRequest) {
        return _navbuilder2.default.pullRequest(pullRequest).diff().build();
    };

    var getPullRequestCommitUrl = function getPullRequestCommitUrl(_ref) {
        var pullRequest = _ref.pullRequest,
            commitId = _ref.commitId;
        return _navbuilder2.default.pullRequest(pullRequest).commit(commitId).build();
    };

    var getPullRequestCommitRageUrl = function getPullRequestCommitRageUrl(_ref2) {
        var pullRequest = _ref2.pullRequest,
            fromCommitId = _ref2.fromCommitId,
            toCommitId = _ref2.toCommitId;
        return _navbuilder2.default.pullRequest(pullRequest).commit(fromCommitId).since(toCommitId).build();
    };

    var ChangesScopeSelector = function (_PureComponent) {
        _inherits(ChangesScopeSelector, _PureComponent);

        function ChangesScopeSelector() {
            var _ref3;

            var _temp, _this, _ret;

            _classCallCheck(this, ChangesScopeSelector);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref3 = ChangesScopeSelector.__proto__ || Object.getPrototypeOf(ChangesScopeSelector)).call.apply(_ref3, [this].concat(args))), _this), _this.selectOption = function (_ref4) {
                var url = _ref4.url;
                var history = _this.props.history;


                history.push(url);
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(ChangesScopeSelector, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.loadDataIfNeeded();
            }
        }, {
            key: 'loadDataIfNeeded',
            value: function loadDataIfNeeded() {
                var _props = this.props,
                    loadCommits = _props.loadCommits,
                    loadUnreviewedCommits = _props.loadUnreviewedCommits,
                    pullRequest = _props.pullRequest,
                    areCommitsLoading = _props.areCommitsLoading,
                    areUnreviewedCommitsLoading = _props.areUnreviewedCommitsLoading;


                if (!areCommitsLoading) {
                    loadCommits({ pullRequest: pullRequest });
                }

                if (!areUnreviewedCommitsLoading) {
                    loadUnreviewedCommits({ pullRequest: pullRequest });
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _props2 = this.props,
                    commit = _props2.commit,
                    sinceCommitId = _props2.sinceCommitId,
                    commits = _props2.commits,
                    pullRequest = _props2.pullRequest,
                    areCommitsLoading = _props2.areCommitsLoading,
                    areChangesLoading = _props2.areChangesLoading,
                    areUnreviewedCommitsLoading = _props2.areUnreviewedCommitsLoading,
                    unreviewedCommits = _props2.unreviewedCommits;


                var isLoading = areCommitsLoading || areChangesLoading || areUnreviewedCommitsLoading;

                var options = [ChangesScopeSelector.getAllChangesOption(pullRequest)].concat(_toConsumableArray(ChangesScopeSelector.getUnreviewedCommitsOption({ pullRequest: pullRequest, unreviewedCommits: unreviewedCommits })), _toConsumableArray(ChangesScopeSelector.getOptionsFromCommits({ pullRequest: pullRequest, commits: commits })));

                var sinceCommit = sinceCommitId ? commits.find(function (_ref5) {
                    var id = _ref5.id;
                    return id === sinceCommitId;
                }) : null;
                var shouldDisplayCommitRange = Boolean(sinceCommit);

                var selectedCommit = commit && options.find(function (_ref6) {
                    var commitId = _ref6.commitId;
                    return commitId === commit.id;
                });
                var selectedOption = selectedCommit || options[0];

                var SingleValueComponent = shouldDisplayCommitRange ? _commitRangeValue2.default : _commitSingleValue2.default;

                return _react2.default.createElement(
                    'div',
                    { className: 'changes-scope-selector' },
                    _react2.default.createElement(_select2.default, {
                        isSearchable: false,
                        value: shouldDisplayCommitRange ? null : selectedOption,
                        options: options,
                        components: {
                            Option: _commitOption2.default,
                            SingleValue: SingleValueComponent,
                            Placeholder: _commitRangeValue2.default
                        },
                        onChange: this.selectOption,
                        onClickPreventDefault: false,
                        styles: {
                            option: _commitOption.styles,
                            menu: commitMenuStyles,
                            control: controlStyles
                        },
                        isLoading: isLoading,
                        shouldDisplayCommitRange: shouldDisplayCommitRange,
                        sinceCommit: sinceCommit,
                        selectedCommit: selectedCommit
                    })
                );
            }
        }], [{
            key: 'getOptionsFromCommits',
            value: function getOptionsFromCommits(_ref7) {
                var pullRequest = _ref7.pullRequest,
                    commits = _ref7.commits;

                return commits.map(function (_ref8) {
                    var message = _ref8.message,
                        commitId = _ref8.id,
                        author = _ref8.author,
                        authorTimestamp = _ref8.authorTimestamp,
                        displayId = _ref8.displayId,
                        parents = _ref8.parents;
                    return {
                        value: commitId,
                        label: message,
                        commitId: commitId,
                        message: message,
                        author: author,
                        date: authorTimestamp,
                        hash: displayId,
                        isMergeCommit: parents.length > 1,
                        url: getPullRequestCommitUrl({ pullRequest: pullRequest, commitId: commitId }),
                        isRange: false
                    };
                });
            }
        }, {
            key: 'getAllChangesOption',
            value: function getAllChangesOption(pullRequest) {
                return {
                    label: _reactI18n.I18n.getText('bitbucket.web.diff.all.changes.displayed'),
                    value: ChangesScopeSelector.DEFAULT_OPTION_VALUE,
                    url: getPullRequestUrl(pullRequest),
                    isRange: false
                };
            }
        }, {
            key: 'getUnreviewedCommitsOption',
            value: function getUnreviewedCommitsOption(_ref9) {
                var pullRequest = _ref9.pullRequest,
                    unreviewedCommits = _ref9.unreviewedCommits;
                var commitsCount = unreviewedCommits.commitsCount,
                    fromHash = unreviewedCommits.fromHash,
                    toHash = unreviewedCommits.toHash;


                if (!commitsCount) {
                    return [];
                } else {
                    return [{
                        label: _reactI18n.I18n.getText('bitbucket.web.diff.show.unreviewed.commits', commitsCount, commitsCount),
                        value: fromHash + ':' + toHash,
                        url: getPullRequestCommitRageUrl({
                            pullRequest: pullRequest,
                            fromCommitId: fromHash,
                            toCommitId: toHash
                        }),
                        isRange: true
                    }];
                }
            }
        }]);

        return ChangesScopeSelector;
    }(_react.PureComponent);

    ChangesScopeSelector.DEFAULT_OPTION_VALUE = 'DEFAULT_OPTION_VALUE';
    ChangesScopeSelector.propTypes = {
        commit: _propTypes.object,
        commits: (0, _propTypes.arrayOf)(_propTypes.object),
        unreviewedCommits: (0, _propTypes.shape)({
            commitsCount: _propTypes.number,
            includesMerge: _propTypes.bool,
            fromHash: _propTypes.string,
            toHash: _propTypes.string
        }),
        pullRequest: _propTypes.object,
        areCommitsLoading: _propTypes.bool,
        areChangesLoading: _propTypes.bool,
        areUnreviewedCommitsLoading: _propTypes.bool,
        loadCommits: _propTypes.func.isRequired,
        loadUnreviewedCommits: _propTypes.func.isRequired,
        history: _propTypes.object.isRequired
    };
    ChangesScopeSelector.defaultProps = {
        commit: null,
        commits: [],
        areCommitsLoading: false,
        areChangesLoading: false,
        areUnreviewedCommitsLoading: false,
        unreviewedCommits: {
            commitsCount: 0,
            includesMerge: false,
            fromHash: null,
            toHash: null
        }
    };
    exports.default = ChangesScopeSelector;
    module.exports = exports['default'];
});