define('bitbucket/internal/model/conflict', ['module', 'exports', '@atlassian/aui', 'backbone-brace', 'bitbucket/internal/model/conflict-change', 'bitbucket/internal/model/file-change-types'], function (module, exports, _aui, _backboneBrace, _conflictChange, _fileChangeTypes) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _backboneBrace2 = _interopRequireDefault(_backboneBrace);

    var _conflictChange2 = _interopRequireDefault(_conflictChange);

    var _fileChangeTypes2 = _interopRequireDefault(_fileChangeTypes);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var messageMatrix = {};

    messageMatrix[_fileChangeTypes2.default.ADD] = {};
    messageMatrix[_fileChangeTypes2.default.ADD][_fileChangeTypes2.default.ADD] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.add.add');
    messageMatrix[_fileChangeTypes2.default.ADD][_fileChangeTypes2.default.RENAME] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.add.rename');
    messageMatrix[_fileChangeTypes2.default.ADD][_fileChangeTypes2.default.MOVE] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.add.move');

    messageMatrix[_fileChangeTypes2.default.MODIFY] = {};
    messageMatrix[_fileChangeTypes2.default.MODIFY][_fileChangeTypes2.default.MODIFY] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.modify.modify');
    messageMatrix[_fileChangeTypes2.default.MODIFY][_fileChangeTypes2.default.RENAME] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.modify.rename');
    messageMatrix[_fileChangeTypes2.default.MODIFY][_fileChangeTypes2.default.MOVE] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.modify.move');
    messageMatrix[_fileChangeTypes2.default.MODIFY][_fileChangeTypes2.default.DELETE] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.modify.delete');

    messageMatrix[_fileChangeTypes2.default.RENAME] = {};
    messageMatrix[_fileChangeTypes2.default.RENAME][_fileChangeTypes2.default.ADD] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.rename.add');
    messageMatrix[_fileChangeTypes2.default.RENAME][_fileChangeTypes2.default.RENAME] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.rename.rename');
    messageMatrix[_fileChangeTypes2.default.RENAME][_fileChangeTypes2.default.MOVE] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.rename.move');
    messageMatrix[_fileChangeTypes2.default.RENAME][_fileChangeTypes2.default.DELETE] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.rename.delete');

    messageMatrix[_fileChangeTypes2.default.MOVE] = {};
    messageMatrix[_fileChangeTypes2.default.MOVE][_fileChangeTypes2.default.ADD] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.move.add');
    messageMatrix[_fileChangeTypes2.default.MOVE][_fileChangeTypes2.default.RENAME] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.move.rename');
    messageMatrix[_fileChangeTypes2.default.MOVE][_fileChangeTypes2.default.MOVE] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.move.move');
    messageMatrix[_fileChangeTypes2.default.MOVE][_fileChangeTypes2.default.DELETE] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.move.delete');

    messageMatrix[_fileChangeTypes2.default.DELETE] = {};
    messageMatrix[_fileChangeTypes2.default.DELETE][_fileChangeTypes2.default.MODIFY] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.delete.modify');
    messageMatrix[_fileChangeTypes2.default.DELETE][_fileChangeTypes2.default.RENAME] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.delete.rename');
    messageMatrix[_fileChangeTypes2.default.DELETE][_fileChangeTypes2.default.MOVE] = AJS.I18n.getText('bitbucket.web.pullrequest.diff.conflict.title.delete.move');

    var Conflict = _backboneBrace2.default.Model.extend({
        namedAttributes: {
            ourChange: _conflictChange2.default,
            theirChange: _conflictChange2.default
        },
        getConflictMessage: function getConflictMessage() {
            //'our' describes the change that was made on the destination branch relative to a shared
            //ancestor with the incoming branch.
            //'their' describes the change that was made on the incoming branch relative to a shared
            //ancestor with the destination branch
            var destinationModState = this.getOurChange() && this.getOurChange().getType();
            var incomingModState = this.getTheirChange() && this.getTheirChange().getType();

            return messageMatrix[incomingModState] && messageMatrix[incomingModState][destinationModState] || '';
        }
    });

    exports.default = Conflict;
    module.exports = exports['default'];
});