define('bitbucket/internal/feature/repository/search-results/search-results-list', ['module', 'exports', 'prop-types', 'react', 'react-dom', './search-results-item'], function (module, exports, _propTypes, _react, _reactDom, _searchResultsItem) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _reactDom2 = _interopRequireDefault(_reactDom);

    var _searchResultsItem2 = _interopRequireDefault(_searchResultsItem);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    // the offset to which focused elements should be scrolled
    var REPOSITORY_LIST_OFFSET = 20;

    var isNotFirstOrLast = function isNotFirstOrLast(el) {
        return el.previousSibling && el.nextSibling;
    };

    var SearchResultsList = function (_Component) {
        _inherits(SearchResultsList, _Component);

        function SearchResultsList() {
            _classCallCheck(this, SearchResultsList);

            return _possibleConstructorReturn(this, (SearchResultsList.__proto__ || Object.getPrototypeOf(SearchResultsList)).apply(this, arguments));
        }

        _createClass(SearchResultsList, [{
            key: 'shouldComponentUpdate',
            value: function shouldComponentUpdate(nextProps) {
                return nextProps.query !== this.props.query || // the query has changed, so the results will be different
                nextProps.repositories !== this.props.repositories || // the total number of repos has changed (clicked "load more")
                nextProps.focusedIndex !== this.props.focusedIndex // the highlighted row has changed
                ;
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(prevProps) {
                // don't scroll the focused element into view if the focused index didn't change
                // this avoids unnecessary updates (and scroll jank) for unrelated component updates.
                if (prevProps && this.props.focusedIndex === prevProps.focusedIndex) {
                    return;
                }
                var focusedEl = this.focusedListEl;
                if (focusedEl) {
                    var prevEl = focusedEl.previousSibling;
                    if (isNotFirstOrLast(focusedEl)) {
                        // Try to make the focused element be the second element in the list if possible
                        this.scrollIntoView(prevEl, prevEl);
                    } else {
                        this.scrollIntoView(focusedEl, prevEl);
                    }
                }
            }
        }, {
            key: 'scrollIntoView',
            value: function scrollIntoView(element, prevEl) {
                if (this.repoList) {
                    this.repoList.scrollTop = prevEl ? element.offsetTop - REPOSITORY_LIST_OFFSET : 0;
                }
            }
        }, {
            key: 'renderListWrapper',
            value: function renderListWrapper(repositories, focusedIndex, onItemClick) {
                var _this2 = this;

                return _react2.default.createElement(
                    'ul',
                    { className: 'repository-list search-results-container' },
                    repositories.map(function (repo, index) {
                        return _react2.default.createElement(_searchResultsItem2.default, {
                            focused: focusedIndex === index,
                            key: repo.id,
                            repository: repo,
                            onItemClick: onItemClick,
                            query: _this2.props.query,
                            ref: function ref(el) {
                                focusedIndex === index ? _this2.focusedListEl = _reactDom2.default.findDOMNode(el) : null;
                            }
                        });
                    })
                );
            }
        }, {
            key: 'render',
            value: function render() {
                var _this3 = this;

                var _props = this.props,
                    EmptyState = _props.EmptyState,
                    focusedIndex = _props.focusedIndex,
                    LoadMore = _props.LoadMore,
                    onItemClick = _props.onItemClick,
                    _onScroll = _props.onScroll,
                    repositories = _props.repositories,
                    title = _props.title;

                return _react2.default.createElement(
                    'div',
                    {
                        className: 'repository-list-container',
                        ref: function ref(el) {
                            _this3.repoList = el;
                        },
                        onScroll: function onScroll(e) {
                            return _onScroll(e.target.scrollTop);
                        }
                    },
                    title,
                    repositories && repositories.length > 0 ? this.renderListWrapper(repositories, focusedIndex, onItemClick) : EmptyState,
                    LoadMore
                );
            }
        }]);

        return SearchResultsList;
    }(_react.Component);

    SearchResultsList.propTypes = {
        repositories: _propTypes2.default.array,
        title: _propTypes2.default.node,
        focusedIndex: _propTypes2.default.number,
        onItemClick: _propTypes2.default.func,
        EmptyState: _propTypes2.default.element,
        LoadMore: _propTypes2.default.element,
        query: _propTypes2.default.string
    };
    exports.default = SearchResultsList;
    module.exports = exports['default'];
});