define('bitbucket/internal/feature/repository/search-results/search-results-item', ['module', 'exports', 'classnames', 'prop-types', 'react', 'bitbucket/util/navbuilder', 'bitbucket/internal/bbui/aui-react/avatar', 'bitbucket/internal/enums', 'bitbucket/internal/util/highlight'], function (module, exports, _classnames, _propTypes, _react, _navbuilder, _avatar, _enums, _highlight) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _highlight2 = _interopRequireDefault(_highlight);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var SearchResultsItem = function (_Component) {
        _inherits(SearchResultsItem, _Component);

        function SearchResultsItem() {
            _classCallCheck(this, SearchResultsItem);

            return _possibleConstructorReturn(this, (SearchResultsItem.__proto__ || Object.getPrototypeOf(SearchResultsItem)).apply(this, arguments));
        }

        _createClass(SearchResultsItem, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    repository = _props.repository,
                    id = _props.id,
                    focused = _props.focused,
                    onItemClick = _props.onItemClick,
                    query = _props.query;
                var repoName = repository.name,
                    _repository$project = repository.project,
                    projectName = _repository$project.name,
                    projectType = _repository$project.type,
                    owner = _repository$project.owner;

                if (query && repoName) {
                    repoName = _react2.default.createElement(_highlight2.default, { text: repoName, query: query, leadingOnly: true });
                    projectName = _react2.default.createElement(_highlight2.default, { text: projectName, query: query, leadingOnly: true });
                }

                return _react2.default.createElement(
                    'li',
                    { className: (0, _classnames2.default)('search-results-item', 'repository', { focused: focused }) },
                    _react2.default.createElement(
                        'a',
                        {
                            href: _navbuilder2.default.project(repository.project).repo(repository).build(),
                            className: 'repository-link',
                            'data-entity': 'repository',
                            'data-repository-id': repository.id,
                            'data-repository-slug': repository.slug,
                            'data-project-id': repository.project.id,
                            'data-project-key': repository.project.key,
                            id: id,
                            title: repository.name,
                            onClick: function onClick(e) {
                                return onItemClick(e);
                            }
                        },
                        projectType === _enums.ProjectType.PERSONAL ? _react2.default.createElement(_avatar.UserAvatar, { person: owner, size: _enums.AvatarTShirtSize.MEDIUM }) : _react2.default.createElement(_avatar.ProjectAvatar, {
                            project: repository.project,
                            size: _enums.AvatarTShirtSize.MEDIUM
                        }),
                        _react2.default.createElement(
                            'div',
                            { className: 'item-wrapper' },
                            _react2.default.createElement(
                                'strong',
                                { className: 'item-name' },
                                repoName
                            ),
                            _react2.default.createElement(
                                'p',
                                { className: 'item-description' },
                                projectName
                            )
                        )
                    )
                );
            }
        }]);

        return SearchResultsItem;
    }(_react.Component);

    SearchResultsItem.propTypes = {
        repository: _propTypes2.default.object.isRequired,
        id: _propTypes2.default.string,
        focused: _propTypes2.default.bool,
        onItemClick: _propTypes2.default.func,
        query: _propTypes2.default.string
    };
    exports.default = SearchResultsItem;
    module.exports = exports['default'];
});