define('bitbucket/internal/feature/repository/inherit-settings-toggle/inherit-settings-toggle', ['exports', '@atlassian/aui', 'jquery', 'lodash', 'bitbucket/internal/bbui/widget/widget', 'bitbucket/internal/widget/are-you-sure/are-you-sure'], function (exports, _aui, _jquery, _lodash, _widget, _areYouSure) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.InheritanceType = undefined;

    var _jquery2 = _interopRequireDefault(_jquery);

    var _widget2 = _interopRequireDefault(_widget);

    var _areYouSure2 = _interopRequireDefault(_areYouSure);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var InheritSettingsToggle = function (_Widget) {
        _inherits(InheritSettingsToggle, _Widget);

        /**
         * @param {jQuery|HTMLElement} container
         * @param {boolean|function} confirmOnInherit
         * @returns {InheritSettingsToggle}
         */
        function InheritSettingsToggle(container) {
            var confirmOnInherit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

            _classCallCheck(this, InheritSettingsToggle);

            var _this = _possibleConstructorReturn(this, (InheritSettingsToggle.__proto__ || Object.getPrototypeOf(InheritSettingsToggle)).call(this));

            (0, _jquery2.default)(container).on('change', 'input[name=inherit-settings-selection]', function (_ref) {
                var target = _ref.target;

                if (target.id === 'inherit-settings-selection-inherit' && ((0, _lodash.isFunction)(confirmOnInherit) ? confirmOnInherit() : confirmOnInherit)) {
                    target.checked = false;
                    document.getElementById('inherit-settings-selection-custom').checked = true;

                    (0, _areYouSure2.default)({
                        title: _aui.I18n.getText('bitbucket.web.repository.settings.inheritedsettingstoggle.warning.title'),
                        bodyContent: _aui.I18n.getText('bitbucket.web.repository.settings.inheritedsettingstoggle.warning.body'),
                        confirmButtonText: _aui.I18n.getText('bitbucket.web.button.remove')
                    }).then(function () {
                        target.checked = true;
                        _this.trigger('change', target.value);
                    });
                } else {
                    _this.trigger('change', target.value);
                }
            });
            return _this;
        }

        return InheritSettingsToggle;
    }(_widget2.default);

    var InheritanceType = exports.InheritanceType = {
        CUSTOM: 'CUSTOM',
        INHERIT: 'INHERIT'
    };

    exports.default = InheritSettingsToggle;
});