define('bitbucket/internal/feature/repository/branch-selector/branch-selector', ['module', 'exports', '@atlassian/aui', 'jquery', 'bitbucket/internal/feature/repository/revision-reference-selector/revision-reference-selector'], function (module, exports, _aui, _jquery, _revisionReferenceSelector) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var AJS = _interopRequireWildcard(_aui);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _revisionReferenceSelector2 = _interopRequireDefault(_revisionReferenceSelector);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    /**
     * A convenience wrapper around RevisionReferenceSelector for showing a selector with only branches.
     * @return {RevisionReferenceSelector} The new RevisionReferenceSelector instance
     *
     * @param {HTMLElement|jQuery}  trigger     The trigger (usually a button) to bind opening the selector to.
     * @param {Object}              options     A hash of options, valid options are specified in RevisionReferenceSelector.prototype.defaults
     */
    function BranchSelector(trigger, options) {
        //A branch selector is just a branches only `RevisionReferenceSelector`
        options = _jquery2.default.extend({
            show: { branches: true, tags: false, commits: false },
            triggerPlaceholder: AJS.I18n.getText('bitbucket.web.branch.selector.default'),
            paginationContext: 'branch-selector'
        }, options);

        return new _revisionReferenceSelector2.default(trigger, options);
    }

    exports.default = BranchSelector;
    module.exports = exports['default'];
});