define('bitbucket/internal/feature/readme/files/readme', ['exports', '@atlassian/aui', 'jquery', 'lodash', 'bitbucket/internal/feature/readme/common/readme-common', 'bitbucket/internal/model/path', 'bitbucket/internal/util/ajax', 'bitbucket/internal/util/events', 'bitbucket/internal/util/syntax-highlight'], function (exports, _aui, _jquery, _lodash, _readmeCommon, _path, _ajax, _events, _syntaxHighlight) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.onReady = undefined;

    var AJS = _interopRequireWildcard(_aui);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _path2 = _interopRequireDefault(_path);

    var _ajax2 = _interopRequireDefault(_ajax);

    var _events2 = _interopRequireDefault(_events);

    var _syntaxHighlight2 = _interopRequireDefault(_syntaxHighlight);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    /** Readme jQuery object */
    var $readme;

    /**
     * Mock Ajax response so we don't have to do null checks.
     */
    var mockResponse = {
        abort: _jquery2.default.noop
    };

    var URL_REGEX = /(?:(https?):\/\/([^\s<]+)|(www\.[^\s<]+?\.[^\s<]+))(?![\.,:])/g;

    /**
     * Finds the readme file in a list containing objects that have the structure {name: "foo"}.
     *
     * The nice thing about doing this here, rather than requesting just the directory is that we cache the result
     * more aggressive (ie based on the file blob). We can pass the supported file extensions via page-data and always
     * request the correct file.
     */
    var findReadmeFile = function findReadmeFile(files, data) {
        var README = data.name,
            extensions = data.extensions;


        var readmeFiles = files.filter(function (_ref) {
            var name = _ref.name,
                type = _ref.type;

            name = name.toUpperCase();
            return (name === README || (0, _lodash.startsWith)(name, README + '.')) && type === 'FILE';
        });

        var filesByExt = (0, _lodash.groupBy)(readmeFiles, function (_ref2) {
            var name = _ref2.name;
            return new _path2.default(name).getExtension().toUpperCase();
        });

        return extensions.map(function (ext) {
            return (0, _lodash.head)(filesByExt[ext.toUpperCase()]);
        }).filter(function (a) {
            return a;
        })[0];
    };

    // Current request in flight
    var currentRequest = mockResponse;

    var markupPlainTextWithLinks = function markupPlainTextWithLinks(content) {
        var extraAttrs = function extraAttrs(url) {
            return url.startsWith(window.location.origin + AJS.contextPath()) ? '' : 'target="_blank" noreferrer noopener';
        };

        var urlWithProtocol = function urlWithProtocol(url) {
            return url.startsWith('www') ? 'http://' + url : url;
        };

        content = AJS.escapeHtml(content).replace(URL_REGEX, function (url) {
            return '<a \n                    href="' + urlWithProtocol(url) + '" \n                    title="' + url + '" \n                    ' + extraAttrs(url) + '>' + url + '</a>';
        });
        return content;
    };
    /**
     * Finds the first readme file, fetches the markup and inserts the result into $readme.
     * @return the ajax response that can be aborted (or a similar mock object).
     */
    var updateFromFirstReadme = function updateFromFirstReadme(_ref3) {
        var files = _ref3.files,
            path = _ref3.path,
            revision = _ref3.revision;

        var extensionsRaw = void 0;
        _readmeCommon.DATA.then(function (data) {
            extensionsRaw = data.extensionsRaw;
            return findReadmeFile(files, data);
        }).done(function (file) {
            if (!file) {
                return;
            }
            var ext = (0, _lodash.last)(file.name.split('.'));
            // if the file has a "raw" extension don't mark it up, if the file has no extension, do mark it up
            var shouldMarkup = !extensionsRaw.includes(ext) || ext === file.name;
            var $content = $readme.find('.filebrowser-readme-content').empty();

            $readme.find('.filebrowser-readme-title').text(file.name);

            var clearReadmeStatus = function clearReadmeStatus() {
                clearReadme();
                return false;
            };

            var showReadme = function showReadme(content) {
                // Move this out of this function to show loading spinner.
                // The downside is what to do with 'unknown' readme types?
                $readme.show();
                if (shouldMarkup) {
                    $content.html((0, _readmeCommon.updateLinks)((0, _jquery2.default)(content), window.location.pathname));
                    _syntaxHighlight2.default.container($content);
                } else {
                    // if the content shouldn't be marked up it should be rendered as plain text
                    // Render it in a <pre> to maintain the whitespace in the file.
                    $content.html('<pre>' + markupPlainTextWithLinks(content) + '</pre>');
                }
                _events2.default.trigger('bitbucket.internal.DO_NOT_USE.feature.readme.rendered');
            };
            path = new _path2.default(path);
            currentRequest = _ajax2.default.rest({
                url: (0, _readmeCommon.createUrl)(path.getComponents().concat(file.name), revision, file.contentId, shouldMarkup),
                dataType: 'html',
                statusCode: {
                    400: clearReadmeStatus,
                    413: function _() {
                        showReadme(AJS.messages.warning({
                            body: AJS.I18n.getText('bitbucket.web.sourceview.readme.toolarge'),
                            closeable: false
                        }));
                        return false;
                    },
                    415: clearReadmeStatus,
                    500: clearReadmeStatus
                }
            }).done(function (content) {
                if (content.trim()) {
                    showReadme(content);
                } else {
                    clearReadme();
                }
            });
        });
    };

    /** Cancel any in-flight calls. Otherwise we introduce a race condition for dirs that don't a readme. */
    var clearReadme = function clearReadme() {
        currentRequest.abort();
        $readme.hide();
    };

    /**
     * Initialises the readme on the first request, and then listens for subsequent directory changes.
     * The initial loading could also be done server side.
     * The disadvantage is for higher-latency users on their first request.
     * The advantage we have with this approach is faster response times, browser caching and having a separate plugin.
     */
    var onReady = function onReady(selector) {
        var cachedData;

        $readme = (0, _jquery2.default)(selector).html(bitbucket.internal.feature.readme.files.readme.readme());
        clearReadme();

        // Listen for url changes and hide the readme view
        _events2.default.on('bitbucket.internal.DO_NOT_USE.page.filebrowser.revisionRefChanged', clearReadme);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.page.filebrowser.urlChanged', clearReadme);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.filetable.showSpinner', clearReadme);

        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.filebrowser.filesChanged', function (data) {
            cachedData = data;
            updateFromFirstReadme(data);
        });

        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.filetable.showFind', clearReadme);
        _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.filetable.hideFind', function () {
            if (cachedData) {
                updateFromFirstReadme(cachedData);
            }
        });
    };

    exports.onReady = onReady;
});