define('bitbucket/internal/feature/project/filterable-project-table/filterable-project-table', ['exports', '@atlassian/aui', 'classnames', 'prop-types', 'react', 'bitbucket/util/navbuilder', 'bitbucket/internal/bbui/aui-react/avatar', 'bitbucket/internal/enums', 'bitbucket/internal/util/highlight', 'bitbucket/internal/widget/filterable-entity-table/filterable-entity-table'], function (exports, _aui, _classnames, _propTypes, _react, _navbuilder, _avatar, _enums, _highlight, _filterableEntityTable) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.ProjectRow = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _highlight2 = _interopRequireDefault(_highlight);

    var _filterableEntityTable2 = _interopRequireDefault(_filterableEntityTable);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var ProjectWithAvatar = function ProjectWithAvatar(_ref) {
        var filter = _ref.filter,
            onProjectClick = _ref.onProjectClick,
            project = _ref.project,
            refCallback = _ref.refCallback;
        return _react2.default.createElement(
            'span',
            { className: 'project-name' },
            _react2.default.createElement(_avatar.Avatar, {
                avatarSrc: project.avatarUrl,
                size: _enums.AvatarTShirtSize.SMALL,
                className: 'aui-avatar-project'
            }),
            _react2.default.createElement(
                'a',
                {
                    href: _navbuilder2.default.project(project).build(),
                    onClick: onProjectClick ? function () {
                        return onProjectClick(project);
                    } : null,
                    ref: function ref(el) {
                        return refCallback ? refCallback(el) : null;
                    }
                },
                _react2.default.createElement(_highlight2.default, { text: project.name, query: filter })
            )
        );
    };

    var PublicLozenge = function PublicLozenge() {
        return _react2.default.createElement(
            'span',
            { className: 'aui-lozenge aui-lozenge-subtle public-lozenge' },
            _aui.I18n.getText('bitbucket.web.repository.public.lozenge')
        );
    };

    var Header = function Header() {
        return _react2.default.createElement(
            'tr',
            null,
            _react2.default.createElement(
                'th',
                { className: 'project-name', scope: 'col' },
                _aui.I18n.getText('bitbucket.web.project.col.name')
            ),
            _react2.default.createElement(
                'th',
                { className: 'project-key', scope: 'col' },
                _aui.I18n.getText('bitbucket.web.project.col.key')
            ),
            _react2.default.createElement(
                'th',
                { className: 'project-description', scope: 'col' },
                _aui.I18n.getText('bitbucket.web.project.col.description')
            )
        );
    };

    /*eslint-disable react/prefer-stateless-function*/

    var ProjectRow = exports.ProjectRow = function (_PureComponent) {
        _inherits(ProjectRow, _PureComponent);

        function ProjectRow() {
            _classCallCheck(this, ProjectRow);

            return _possibleConstructorReturn(this, (ProjectRow.__proto__ || Object.getPrototypeOf(ProjectRow)).apply(this, arguments));
        }

        _createClass(ProjectRow, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    filter = _props.filter,
                    focused = _props.focused,
                    onProjectClick = _props.onProjectClick,
                    primaryRefCallback = _props.primaryRefCallback,
                    project = _props.project;


                return _react2.default.createElement(
                    'tr',
                    { className: (0, _classnames2.default)({ focused: focused }) },
                    _react2.default.createElement(
                        'td',
                        { className: 'project-name' },
                        _react2.default.createElement(ProjectWithAvatar, {
                            filter: filter,
                            onProjectClick: onProjectClick,
                            refCallback: primaryRefCallback,
                            project: project
                        }),
                        project.public && _react2.default.createElement(PublicLozenge, null)
                    ),
                    _react2.default.createElement(
                        'td',
                        { className: 'project-key' },
                        project.key
                    ),
                    _react2.default.createElement(
                        'td',
                        { className: 'project-description' },
                        _react2.default.createElement(
                            'span',
                            { title: project.description },
                            project.description
                        )
                    )
                );
            }
        }]);

        return ProjectRow;
    }(_react.PureComponent);

    ProjectRow.propTypes = {
        focused: _propTypes2.default.bool,
        onProjectClick: _propTypes2.default.func,
        primaryRefCallback: _propTypes2.default.func,
        project: _propTypes2.default.object
    };

    var FilterableProjectTable = function (_FilterableEntityTabl) {
        _inherits(FilterableProjectTable, _FilterableEntityTabl);

        function FilterableProjectTable() {
            var _ref2;

            var _temp, _this2, _ret;

            _classCallCheck(this, FilterableProjectTable);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this2 = _possibleConstructorReturn(this, (_ref2 = FilterableProjectTable.__proto__ || Object.getPrototypeOf(FilterableProjectTable)).call.apply(_ref2, [this].concat(args))), _this2), _this2.onProjectClick = function (project) {
                var _this2$props = _this2.props,
                    entities = _this2$props.entities,
                    filter = _this2$props.filter,
                    onProjectClick = _this2$props.onProjectClick;


                onProjectClick && onProjectClick(project, filter, entities);
            }, _this2.row = function (_ref3) {
                var project = _ref3.item,
                    focused = _ref3.focused,
                    primaryRefCallback = _ref3.primaryRefCallback;
                return _react2.default.createElement(ProjectRow, {
                    filter: _this2.props.filter,
                    focused: focused,
                    key: project.id,
                    onProjectClick: _this2.onProjectClick,
                    primaryRefCallback: primaryRefCallback,
                    project: project
                });
            }, _temp), _possibleConstructorReturn(_this2, _ret);
        }

        return FilterableProjectTable;
    }(_filterableEntityTable2.default);

    FilterableProjectTable.defaultProps = _extends({}, _filterableEntityTable2.default.defaultProps, {
        className: 'filterable-project-table',
        filterable: false,
        header: Header,
        lastPageMessage: _aui.I18n.getText('bitbucket.web.project.allfetched'),
        loadMoreMessage: _aui.I18n.getText('bitbucket.web.project.loadmore'),
        noItemsMessage: _aui.I18n.getText('bitbucket.web.project.nonefound'),
        filterPlaceholder: _aui.I18n.getText('bitbucket.web.project.filter.placeholder')
    });
    FilterableProjectTable.propTypes = _extends({}, _filterableEntityTable2.default.propTypes, {
        onProjectClick: _propTypes2.default.func,
        primaryRefCallback: _propTypes2.default.func
    });
    exports.default = FilterableProjectTable;
});