define('bitbucket/internal/feature/labels/repository/label-repositories-dialog-content', ['module', 'exports', '@atlassian/aui', 'icepick', 'prop-types', 'react', 'react-redux', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state', 'bitbucket/internal/enums', 'bitbucket/internal/feature/repository/filterable-repository-table/action-creators', 'bitbucket/internal/feature/repository/filterable-repository-table/actions', 'bitbucket/internal/feature/repository/filterable-repository-table/filterable-repository-table', 'bitbucket/internal/util/analytics', 'bitbucket/internal/widget/filterable-entity-table/entity-rest-actor', 'bitbucket/internal/widget/filterable-entity-table/filterable-entity-table', 'bitbucket/internal/widget/filterable-entity-table/store'], function (module, exports, _aui, _icepick, _propTypes, _react, _reactRedux, _navbuilder, _server, _state, _enums, _actionCreators, _actions, _filterableRepositoryTable, _analytics, _entityRestActor, _filterableEntityTable, _store) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    var _filterableRepositoryTable2 = _interopRequireDefault(_filterableRepositoryTable);

    var _analytics2 = _interopRequireDefault(_analytics);

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var ConnectedTable = (0, _filterableEntityTable.connectEntityTable)(_enums.Entity.REPOSITORY, _actions.LOAD_REPOSITORIES, _filterableRepositoryTable2.default);

    var LabelRepositoriesDialogContent = function (_Component) {
        _inherits(LabelRepositoriesDialogContent, _Component);

        function LabelRepositoriesDialogContent(props) {
            _classCallCheck(this, LabelRepositoriesDialogContent);

            var _this = _possibleConstructorReturn(this, (LabelRepositoriesDialogContent.__proto__ || Object.getPrototypeOf(LabelRepositoriesDialogContent)).call(this, props));

            var urlBuilder = function urlBuilder() {
                return _navbuilder2.default.rest().addPathComponents('labels', _this.props.labelName, 'labeled').withParams({ avatarSize: _enums.AvatarSize.SMALL, type: 'repository' });
            };

            _this.store = (0, _store2.default)({
                actors: [(0, _entityRestActor.loadEntitiesRestActor)({
                    loadAction: _actions.LOAD_REPOSITORIES,
                    urlBuilder: urlBuilder,
                    responseTransformer: _this.responseTransformer(),
                    statusCode: {
                        404: _server.createEmptyPage //return nothing if by any chance the label has already been deleted
                    }
                })],
                entityName: _enums.Entity.REPOSITORY,
                loadAction: _actions.LOAD_REPOSITORIES
            });
            return _this;
        }

        _createClass(LabelRepositoriesDialogContent, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                var repositoryPage = { isLastPage: false, values: [], size: 0, limit: 25 };
                this.store.dispatch((0, _actionCreators.populateRepositories)(repositoryPage));
            }
        }, {
            key: 'responseTransformer',
            value: function responseTransformer() {
                return function (response) {
                    return (0, _icepick.set)(response, 'values', response.values.filter(function (repository) {
                        return repository.id !== _state2.default.getRepository().id;
                    }));
                };
            }
        }, {
            key: 'render',
            value: function render() {
                var _props = this.props,
                    dialogContentEl = _props.dialogContentEl,
                    scrollToLoad = _props.scrollToLoad;
                // Extend props

                return _react2.default.createElement(
                    _reactRedux.Provider,
                    { store: this.store },
                    _react2.default.createElement(ConnectedTable, {
                        emptyState: _react2.default.createElement(
                            'h3',
                            { className: 'entity-empty' },
                            _aui.I18n.getText('bitbucket.web.label.search.empty')
                        ),
                        showProject: true,
                        showPublic: true,
                        shouldScrollOnFocus: false,
                        scrollElement: dialogContentEl,
                        scrollToLoad: scrollToLoad,
                        onRepoClick: function onRepoClick(repository) {
                            _analytics2.default.add('stash.client.repository.label.dialog.repository.clicked', {
                                'project.id': repository.project.id,
                                'repository.id': repository.id
                            });
                        },
                        showTableIfNoResults: false
                    })
                );
            }
        }]);

        return LabelRepositoriesDialogContent;
    }(_react.Component);

    LabelRepositoriesDialogContent.propTypes = {
        labelName: _propTypes2.default.string.isRequired,
        scrollToLoad: _propTypes2.default.bool
    };
    LabelRepositoriesDialogContent.defaultProps = {
        scrollToLoad: true
    };
    exports.default = LabelRepositoriesDialogContent;
    module.exports = exports['default'];
});