define('bitbucket/internal/feature/inbox/inbox', ['module', 'exports', '@atlassian/aui', 'jquery', 'lodash', 'bitbucket/util/events', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state'], function (module, exports, _aui, _jquery, _lodash, _events, _navbuilder, _server, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _events2 = _interopRequireDefault(_events);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _server2 = _interopRequireDefault(_server);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    var getInboxCountResourceUrl = function getInboxCountResourceUrl() {
        return _navbuilder2.default.rest().addPathComponents('inbox', 'pull-requests', 'count').build();
    };

    var InboxDialog = function () {
        function InboxDialog() {
            var _this = this;

            _classCallCheck(this, InboxDialog);

            this.whenInboxCountFetched = function (data) {
                _this.$inboxTrigger.attr('aria-label', _aui.I18n.getText('bitbucket.web.header.inbox.menu.aria.label', data.count));

                if (data.count > 0) {
                    var $badge = (0, _jquery2.default)(aui.badges.badge({
                        text: data.count
                    }));

                    _this.$inboxTrigger.html(bitbucket.internal.feature.inbox.inbox.triggerIcon()).append($badge);

                    // Needed for the transition to trigger
                    (0, _lodash.defer)(function () {
                        $badge.addClass('visible');
                    });
                } else {
                    // The badge fadeOut transition happens with a CSS3 transition, which we can't hook into.
                    // Use a setTimeout instead, unfortunately.
                    var cssTransitionDuration = 500;

                    _this.$inboxTrigger.find('.aui-badge').removeClass('visible');

                    setTimeout(function () {
                        _this.$inboxTrigger.html(bitbucket.internal.feature.inbox.inbox.triggerIcon());
                    }, cssTransitionDuration);
                }

                _this.$inboxTrigger.attr('data-countLoaded', true);
            };

            this.onShowDialog = function () {
                (0, _jquery2.default)(document).on('keyup', _this.hideOnEscapeKeyUp);

                /*
                 * This has been added for interaction with the other dialogs using dialog2,
                 * and so the inline dialog for the inbox doesn't know about them which causes
                 * layering issues when they're opened from the PR list.
                 *
                 * This might be able to be removed in future if there's an InlineDialog2
                 * and the Inbox is updated to use it.
                 */
                _aui.dialog2.on('show', _this.hideOnDialogShown);

                /*
                 * This has been added for interaction with drop down menus that stay
                 * shown even with the inbox dialog shown. See BSERV-7835
                 */
                (0, _jquery2.default)('.aui-dropdown2-active').trigger('aui-button-invoke');

                _this.loadDialogResources().then(_this.initialiseDialog);
            };

            this.onHideDialog = function () {
                (0, _jquery2.default)(document).off('keyup', _this.hideOnEscapeKeyUp);
                _aui.dialog2.off('show', _this.hideOnDialogShown);

                if ((0, _jquery2.default)(document.activeElement).closest('#' + InboxDialog.DIALOG_ID).length) {
                    // if the focus is inside the dialog, you get stuck when it closes.
                    document.activeElement.blur();
                }
            };

            this.hideOnEscapeKeyUp = function (e) {
                if (e.keyCode === _jquery2.default.ui.keyCode.ESCAPE) {
                    _this.$inboxInlineDialog.attr('open', false);
                    e.preventDefault();
                }
            };

            this.hideOnDialogShown = function () {
                _this.$inboxInlineDialog.attr('open', false);
            };

            this.loadDialogResources = (0, _lodash.once)(function () {
                var $spinner = this.$inboxInlineDialog.find('aui-spinner');

                return new Promise(function (resolve) {
                    window.WRM.require('wrc!bitbucket.pullRequest.inbox').done(function () {
                        $spinner.remove();
                        resolve();
                    }).always(function () {
                        $spinner.remove();
                    });
                });
            });

            this.initialiseDialog = function () {
                var dialogContent = _this.$inboxInlineDialog.find('.aui-inline-dialog-contents')[0];

                // pass null as second param to prevent the require from being extracted to the top level AMD module by the babel transform
                window.require('bitbucket/internal/feature/inbox/inbox-dialog', null).onReady(dialogContent);
            };

            this.$inboxTrigger = (0, _jquery2.default)('#' + InboxDialog.TRIGGER_ID);

            if (!this.$inboxTrigger.length || !_state2.default.getCurrentUser()) {
                return;
            }

            this.initializeInlineDialog();
            this.addEventListeners();
        }

        _createClass(InboxDialog, [{
            key: 'initializeInlineDialog',
            value: function initializeInlineDialog() {
                this.$inboxInlineDialog = (0, _jquery2.default)('#' + InboxDialog.DIALOG_ID);
                this.$inboxInlineDialog.on('aui-show', this.onShowDialog).on('aui-hide', this.onHideDialog);

                this.updateInboxCount();
            }
        }, {
            key: 'addEventListeners',
            value: function addEventListeners() {
                var _this2 = this;

                var reviewerStatusUpdateHandler = function reviewerStatusUpdateHandler(data) {
                    if (data.user.name === _state2.default.getCurrentUser().name) {
                        _this2.updateInboxCount();
                    }
                };

                _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.approve-button.added', reviewerStatusUpdateHandler);
                _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.approve-button.removed', reviewerStatusUpdateHandler);
                _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.needs-work.added', reviewerStatusUpdateHandler);
                _events2.default.on('bitbucket.internal.DO_NOT_USE.widget.needs-work.removed', reviewerStatusUpdateHandler);
                _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.pullRequest.self.added', reviewerStatusUpdateHandler);
                _events2.default.on('bitbucket.internal.DO_NOT_USE.feature.pullRequest.self.removed', reviewerStatusUpdateHandler);
            }
        }, {
            key: 'updateInboxCount',
            value: function updateInboxCount() {
                this.fetchInboxCount().then(this.whenInboxCountFetched);
            }
        }, {
            key: 'fetchInboxCount',
            value: function fetchInboxCount() {
                return _server2.default.rest({
                    url: getInboxCountResourceUrl(),
                    type: 'GET',
                    statusCode: {
                        '*': false
                    }
                });
            }
        }]);

        return InboxDialog;
    }();

    InboxDialog.TRIGGER_ID = 'inbox-trigger';
    InboxDialog.DIALOG_ID = 'inline-dialog-inbox-pull-requests-content';


    function onReady() {
        new InboxDialog();
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});