define('bitbucket/internal/feature/inbox/inbox-dialog', ['exports', '@atlassian/aui', 'jquery', 'lodash', 'react', 'react-dom', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state', 'bitbucket/internal/bbui/inbox/inbox', 'bitbucket/internal/enums'], function (exports, _aui, _jquery, _lodash, _react, _reactDom, _navbuilder, _server, _state2, _inbox, _enums) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.onReady = onReady;

    var AJS = _interopRequireWildcard(_aui);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _react2 = _interopRequireDefault(_react);

    var _reactDom2 = _interopRequireDefault(_reactDom);

    var _navbuilder2 = _interopRequireDefault(_navbuilder);

    var _server2 = _interopRequireDefault(_server);

    var _state3 = _interopRequireDefault(_state2);

    var _inbox2 = _interopRequireDefault(_inbox);

    var _enums2 = _interopRequireDefault(_enums);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var container = void 0;

    var InboxView = function (_Component) {
        _inherits(InboxView, _Component);

        function InboxView(props) {
            _classCallCheck(this, InboxView);

            var _this = _possibleConstructorReturn(this, (InboxView.__proto__ || Object.getPrototypeOf(InboxView)).call(this, props));

            _this.onMorePrsRequested = function (tableProp) {
                if (_this.state[tableProp].loading) {
                    return;
                }
                _this.setState(_defineProperty({}, tableProp, _extends({}, _this.state[tableProp], {
                    loading: true
                })));

                _server2.default.rest({
                    url: _this.getInboxResourceUrlBuilder(tableProp).build(),
                    type: 'GET',
                    statusCode: {
                        0: _this.handleError,
                        401: _this.handleError,
                        500: _this.handleError,
                        502: _this.handleError
                    }
                }).done(function (data) {
                    _this.setState(_defineProperty({}, tableProp, _extends({}, _this.state[tableProp], {
                        pullRequests: _this.state[tableProp].pullRequests.concat(data.values),
                        loading: false,
                        allFetched: data.isLastPage,
                        nextPageStart: (0, _lodash.get)(data, 'nextPageStart', 0)
                    })));
                });
            };

            _this.getInboxResourceUrlBuilder = function (tableProp) {
                var role = _this.mapTablePropToRole[tableProp];

                return _navbuilder2.default.rest().addPathComponents('inbox', 'pull-requests').withParams({
                    role: role,
                    start: _this.state[tableProp].nextPageStart,
                    limit: _this.props.pageSize,
                    avatarSize: bitbucket.internal.widget.avatar.avatar.avatarSizeInPx({
                        size: 'medium'
                    }),
                    withAttributes: true,
                    state: 'OPEN',
                    order: 'oldest'
                });
            };

            _this.mapTablePropToRole = {
                created: _enums2.default.ParticipantRole.AUTHOR,
                reviewing: _enums2.default.ParticipantRole.REVIEWER
            };


            _this.state = {
                created: {
                    pullRequests: [],
                    allFetched: false,
                    loading: false,
                    nextPageStart: 0,
                    onMoreItemsRequested: function onMoreItemsRequested() {
                        return _this.onMorePrsRequested('created');
                    }
                },
                reviewing: {
                    pullRequests: [],
                    allFetched: false,
                    loading: false,
                    nextPageStart: 0,
                    onMoreItemsRequested: function onMoreItemsRequested() {
                        return _this.onMorePrsRequested('reviewing');
                    }
                }
            };
            return _this;
        }

        _createClass(InboxView, [{
            key: 'handleError',
            value: function handleError(xhr, textStatus, errorThrown, response) {
                var responseError = {};
                if (response) {
                    responseError = response.errors ? response.errors[0] : response;
                }
                _reactDom2.default.unmountComponentAtNode(container);

                (0, _jquery2.default)(container).html((0, _jquery2.default)(bitbucket.internal.feature.inbox.inbox.error({
                    title: AJS.I18n.getText('bitbucket.web.header.inbox.error.title'),
                    text: responseError.message || AJS.I18n.getText('bitbucket.web.header.inbox.error.unknown')
                })));
                return false;
            }
        }, {
            key: 'render',
            value: function render() {
                var _state = this.state,
                    created = _state.created,
                    reviewing = _state.reviewing;
                var _props = this.props,
                    currentUser = _props.currentUser,
                    pageSize = _props.pageSize;


                return _react2.default.createElement(_inbox2.default, { created: created, currentUser: currentUser, pageSize: pageSize, reviewing: reviewing });
            }
        }]);

        return InboxView;
    }(_react.Component);

    function onReady(dialogContent) {
        var currentUser = _state3.default.getCurrentUser();

        if (dialogContent && currentUser) {
            container = dialogContent;
            _reactDom2.default.render(_react2.default.createElement(InboxView, { currentUser: currentUser, pageSize: _inbox.DEFAULT_PAGE_SIZE }), dialogContent);
        }
    }
});