define('bitbucket/internal/feature/dashboard/reducers/ui/pull-request-suggestions', ['module', 'exports', 'lodash', 'bitbucket/internal/feature/dashboard/actions', 'bitbucket/internal/util/store/reducers'], function (module, exports, _lodash, _actions, _reducers) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _reduceByType;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var loadPullRequestSuggestions = function loadPullRequestSuggestions(state) {
        return _extends({}, state, { loading: true });
    };
    var loadPullRequestSuggestionsComplete = function loadPullRequestSuggestionsComplete(state) {
        return _extends({}, state, {
            loading: false
        });
    };

    var makeUpdater = function makeUpdater(update) {
        return function (state, _ref) {
            var meta = _ref.meta;
            return (0, _lodash.merge)({}, state, {
                suggestions: _defineProperty({}, meta.suggestionId, update)
            });
        };
    };

    var loadPullRequestSuggestionCommits = makeUpdater({ loading: true });
    var loadPullRequestSuggestionCommitsSuccess = makeUpdater({ loading: false });
    var loadPullRequestSuggestionCommitsFailure = makeUpdater({
        loading: false,
        open: false
    });
    var openPullRequestSuggestionCommits = makeUpdater({ open: true });
    var closePullRequestSuggestionCommits = makeUpdater({ open: false });

    exports.default = (0, _reducers.reduceByType)({}, (_reduceByType = {}, _defineProperty(_reduceByType, _actions.LOAD_PULL_REQUEST_SUGGESTIONS, loadPullRequestSuggestions), _defineProperty(_reduceByType, _actions.LOAD_PULL_REQUEST_SUGGESTIONS_SUCCESS, loadPullRequestSuggestionsComplete), _defineProperty(_reduceByType, _actions.LOAD_PULL_REQUEST_SUGGESTIONS_FAILURE, loadPullRequestSuggestionsComplete), _defineProperty(_reduceByType, _actions.LOAD_PULL_REQUEST_SUGGESTION_COMMITS, loadPullRequestSuggestionCommits), _defineProperty(_reduceByType, _actions.LOAD_PULL_REQUEST_SUGGESTION_COMMITS_SUCCESS, loadPullRequestSuggestionCommitsSuccess), _defineProperty(_reduceByType, _actions.LOAD_PULL_REQUEST_SUGGESTION_COMMITS_FAILURE, loadPullRequestSuggestionCommitsFailure), _defineProperty(_reduceByType, _actions.OPEN_PULL_REQUEST_SUGGESTION_COMMITS, openPullRequestSuggestionCommits), _defineProperty(_reduceByType, _actions.CLOSE_PULL_REQUEST_SUGGESTION_COMMITS, closePullRequestSuggestionCommits), _reduceByType));
    module.exports = exports['default'];
});