define('bitbucket/internal/feature/dashboard/reducers/entities/repositories', ['module', 'exports', 'bitbucket/internal/util/store/reducers', '../../actions'], function (module, exports, _reducers, _actions) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    exports.default = (0, _reducers.reduceByType)({}, _defineProperty({}, _actions.LOAD_REPOSITORIES_SUCCESS, function (state, action) {
        // TODO this reducer should be smarter about when new objects are created to ensure downstream component update / memoisation is correct
        var repos = action.payload.values.reduce(function (memo, repo) {
            if (state.hasOwnProperty(repo.id)) {
                memo[repo.id] = _extends({}, state[repo.id], repo);
            } else {
                memo[repo.id] = repo;
            }

            return memo;
        }, {});

        return _extends({}, state, repos);
    }));
    module.exports = exports['default'];
});