define('bitbucket/internal/feature/dashboard/reducers/entities/pull-requests', ['module', 'exports', 'bitbucket/internal/bbui/utils/pull-request-unique-id', 'bitbucket/internal/util/store/reducers', '../../actions'], function (module, exports, _pullRequestUniqueId, _reducers, _actions) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _pullRequestUniqueId2 = _interopRequireDefault(_pullRequestUniqueId);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    exports.default = (0, _reducers.reduceByType)({}, _defineProperty({}, _actions.LOAD_PULL_REQUESTS_SUCCESS, function (state, action) {
        var pullRequests = _extends({}, state);

        action.payload.values.forEach(function (pullRequest) {
            // This is inefficient. We do this to re-trigger the fetch of the build status
            pullRequests[(0, _pullRequestUniqueId2.default)(pullRequest)] = pullRequest;
        });

        return pullRequests;
    }));
    module.exports = exports['default'];
});