define('bitbucket/internal/feature/dashboard/containers/pull-request-suggestions', ['exports', 'lodash', 'react', 'react-redux', 'redux', 'bitbucket/util/scheduler', 'bitbucket/internal/util/analytics', 'bitbucket/internal/util/property', '../action-creators/load-pull-request-suggestions', '../action-creators/suggestion-commits', '../components/pull-request-suggestion', '../components/pull-request-suggestion-web-section', '../selectors/pull-request-suggestions'], function (exports, _lodash, _react, _reactRedux, _redux, _scheduler, _analytics, _property, _loadPullRequestSuggestions, _suggestionCommits, _pullRequestSuggestion, _pullRequestSuggestionWebSection, _pullRequestSuggestions) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.PullRequestSuggestions = undefined;

    var _react2 = _interopRequireDefault(_react);

    var _scheduler2 = _interopRequireDefault(_scheduler);

    var _analytics2 = _interopRequireDefault(_analytics);

    var _property2 = _interopRequireDefault(_property);

    var _loadPullRequestSuggestions2 = _interopRequireDefault(_loadPullRequestSuggestions);

    var _suggestionCommits2 = _interopRequireDefault(_suggestionCommits);

    var _pullRequestSuggestion2 = _interopRequireDefault(_pullRequestSuggestion);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var pollIntervalPromise = _property2.default.getFromProvider('dashboard.poll.pull-request-suggestions.interval');

    var PullRequestSuggestions = exports.PullRequestSuggestions = function (_Component) {
        _inherits(PullRequestSuggestions, _Component);

        function PullRequestSuggestions() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, PullRequestSuggestions);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = PullRequestSuggestions.__proto__ || Object.getPrototypeOf(PullRequestSuggestions)).call.apply(_ref, [this].concat(args))), _this), _this.itemClick = function (suggestion) {
                var _suggestion$open = suggestion.open,
                    open = _suggestion$open === undefined ? false : _suggestion$open,
                    _suggestion$commits = suggestion.commits,
                    commits = _suggestion$commits === undefined ? [] : _suggestion$commits;


                if (!open) {
                    !commits.length && _this.props.loadPullRequestSuggestionCommits(suggestion);
                    _this.props.openPullRequestSuggestionCommits(suggestion);
                    _analytics2.default.add('dashboard.pullrequest-suggestion.expand');
                } else {
                    _this.props.closePullRequestSuggestionCommits(suggestion);
                    _analytics2.default.add('dashboard.pullrequest-suggestion.collapse');
                }
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(PullRequestSuggestions, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                var _this2 = this;

                pollIntervalPromise.done(function (pollInterval) {
                    if (pollInterval < 1) {
                        // If the interval is configured with a 0 or negative value, don't enable polling
                        return;
                    }
                    _this2.schedule = new _scheduler2.default({
                        backoff: {
                            onBlur: true,
                            onInactive: true
                        },
                        interval: pollInterval,
                        maxInterval: 10 * _scheduler.MINUTE, // keep the maxInterval value in sync with the max value mentioned in application-internal.properties
                        job: _this2.props.loadPullRequestSuggestions
                    });
                    _this2.schedule.start();
                });
            }
        }, {
            key: 'componentWillUnmount',
            value: function componentWillUnmount() {
                if (this.schedule) {
                    this.schedule.stop();
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _this3 = this;

                var pullRequestSuggestions = this.props.pullRequestSuggestions;

                var webSections = (0, _pullRequestSuggestionWebSection.getWebSections)();

                return _react2.default.createElement(
                    'div',
                    { className: 'dashboard-pull-request-suggestions' },
                    (0, _lodash.map)(pullRequestSuggestions, function (suggestion) {
                        return _react2.default.createElement(_pullRequestSuggestion2.default, {
                            key: suggestion.id,
                            suggestion: suggestion,
                            onClick: _this3.itemClick,
                            webSections: webSections
                        });
                    })
                );
            }
        }]);

        return PullRequestSuggestions;
    }(_react.Component);

    function mapDispatchToProps(dispatch) {
        return (0, _redux.bindActionCreators)({
            loadPullRequestSuggestions: _loadPullRequestSuggestions2.default,
            loadPullRequestSuggestionCommits: _suggestionCommits2.default,
            openPullRequestSuggestionCommits: _suggestionCommits.openPullRequestSuggestionCommits,
            closePullRequestSuggestionCommits: _suggestionCommits.closePullRequestSuggestionCommits
        }, dispatch);
    }

    function mapStateToProps(state) {
        return {
            isLoading: (0, _lodash.get)(state, 'ui.pullRequestSuggestions.meta.loading'),
            pullRequestSuggestions: (0, _pullRequestSuggestions.pullRequestSuggestionsSelector)(state)
        };
    }

    exports.default = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(PullRequestSuggestions);
});