define('bitbucket/internal/feature/alerts/reducers', ['module', 'exports', 'lodash', 'bitbucket/internal/util/store/reducers', './actions'], function (module, exports, _lodash, _reducers, _actions) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _reduceByType;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function addAlert(state, action) {
        return _extends({}, state, {
            alerts: _extends({}, state.alerts, _defineProperty({}, action.payload.alertKey, _extends({}, action.payload)))
        });
    }

    function removeAlert(state, action) {
        return _extends({}, state, {
            alerts: (0, _lodash.omit)(state.alerts, action.payload)
        });
    }

    function toggleDialog(state, open) {
        return _extends({}, state, {
            dialog: _extends({}, state.dialog, {
                open: open
            })
        });
    }

    exports.default = (0, _reducers.reduceByType)({
        alerts: {},
        dialog: {
            open: false
        }
    }, (_reduceByType = {}, _defineProperty(_reduceByType, _actions.ADD_ALERT, addAlert), _defineProperty(_reduceByType, _actions.REMOVE_ALERT, removeAlert), _defineProperty(_reduceByType, _actions.DIALOG_CLOSED, function (state) {
        return toggleDialog(state, false);
    }), _defineProperty(_reduceByType, _actions.DIALOG_OPEN, function (state) {
        return toggleDialog(state, true);
    }), _reduceByType));
    module.exports = exports['default'];
});