define('bitbucket/internal/feature/alerts/action-creators', ['exports', './actions'], function (exports, _actions) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.openDialog = exports.closeDialog = exports.remove = exports.add = undefined;

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function generateKey(alert) {
        return alert.title.toLowerCase().split(' ').join('') + Date.now();
    }

    var add = exports.add = function add(payload) {
        return {
            type: _actions.ADD_ALERT,
            payload: _extends({
                alertKey: generateKey(payload)
            }, payload)
        };
    };

    var remove = exports.remove = function remove(payload) {
        return {
            type: _actions.REMOVE_ALERT,
            payload: payload
        };
    };

    var closeDialog = exports.closeDialog = function closeDialog() {
        return {
            type: _actions.DIALOG_CLOSED
        };
    };

    var openDialog = exports.openDialog = function openDialog() {
        return {
            type: _actions.DIALOG_OPEN
        };
    };
});