define('bitbucket/internal/feature/admin/storage/add-store-dialog', ['module', 'exports', '@atlassian/aui', 'prop-types', 'react', 'bitbucket/internal/bbui/aui-react/dialog', 'bitbucket/internal/bbui/aui-react/spinner', 'bitbucket/internal/bbui/tipsy/tipsy', 'bitbucket/internal/util/text', 'bitbucket/internal/widget/icons/icons'], function (module, exports, _aui, _propTypes, _react, _dialog, _spinner, _tipsy, _text, _icons) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _dialog2 = _interopRequireDefault(_dialog);

    var _spinner2 = _interopRequireDefault(_spinner);

    var _tipsy2 = _interopRequireDefault(_tipsy);

    var _text2 = _interopRequireDefault(_text);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var MAX_PATH_LENGTH = 128;

    var FooterActionButtons = function FooterActionButtons(_ref) {
        var createStore = _ref.createStore,
            onCloseDialog = _ref.onCloseDialog,
            saving = _ref.saving,
            validationRequired = _ref.validationRequired;

        var disabled = saving || validationRequired;

        return _react2.default.createElement(
            'div',
            { className: 'buttons-container add-store-dialog-footer' },
            _react2.default.createElement(
                'div',
                { className: 'buttons spinner-button' },
                saving && _react2.default.createElement(_spinner2.default, null),
                _react2.default.createElement(
                    _tipsy2.default,
                    {
                        title: _aui.I18n.getText('bitbucket.web.admin.storage.check.path.first'),
                        condition: function condition() {
                            return validationRequired;
                        },
                        gravity: 's',
                        className: 'add-store-button-tooltip'
                    },
                    _react2.default.createElement(
                        'button',
                        {
                            className: 'aui-button aui-button-primary',
                            disabled: disabled,
                            onClick: createStore
                        },
                        _aui.I18n.getText('bitbucket.web.admin.storage.add.data.store')
                    )
                ),
                _react2.default.createElement(
                    'button',
                    { className: 'aui-button aui-button-link', onClick: onCloseDialog },
                    _aui.I18n.getText('bitbucket.web.button.cancel')
                )
            )
        );
    };

    FooterActionButtons.propTypes = {
        createStore: _propTypes2.default.func.isRequired,
        onCloseDialog: _propTypes2.default.func.isRequired,
        saving: _propTypes2.default.bool,
        validationRequired: _propTypes2.default.bool.isRequired
    };

    var Errors = function Errors(_ref2) {
        var errors = _ref2.errors;
        return _react2.default.createElement(
            'div',
            { className: 'description invalid-path' },
            errors.map(function (error) {
                return _react2.default.createElement(
                    'div',
                    { key: error.message, className: 'error-message' },
                    _react2.default.createElement(_icons.ErrorIcon, { key: error.message }),
                    error.message,
                    error.nodes && error.nodes.length > 0 ? _react2.default.createElement(
                        'ul',
                        null,
                        error.nodes.map(function (node) {
                            var hostAndPort = node.address.hostName + ':' + node.address.port;
                            var nodeDescription = node.name ? node.name + ' (' + hostAndPort + ')' : '' + hostAndPort;

                            return _react2.default.createElement(
                                'li',
                                { className: 'node', key: node.id },
                                nodeDescription
                            );
                        })
                    ) : null
                );
            })
        );
    };

    Errors.propTypes = {
        errors: _propTypes2.default.arrayOf(_propTypes2.default.object)
    };

    var AddStoreDialog = function (_Component) {
        _inherits(AddStoreDialog, _Component);

        function AddStoreDialog() {
            var _ref3;

            var _temp, _this, _ret;

            _classCallCheck(this, AddStoreDialog);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref3 = AddStoreDialog.__proto__ || Object.getPrototypeOf(AddStoreDialog)).call.apply(_ref3, [this].concat(args))), _this), _this.pathTextInput = _react2.default.createRef(), _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(AddStoreDialog, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                this.pathTextInput.current.focus();
            }
        }, {
            key: 'render',
            value: function render() {
                var _props = this.props,
                    createStore = _props.createStore,
                    errors = _props.errors,
                    onCloseDialog = _props.onCloseDialog,
                    onInputChange = _props.onInputChange,
                    path = _props.path,
                    pathInfo = _props.pathInfo,
                    saving = _props.saving,
                    validatePath = _props.validatePath;


                return _react2.default.createElement(
                    _dialog2.default,
                    {
                        id: 'add-data-store-dialog',
                        size: _dialog.DialogSize.LARGE,
                        titleContent: _aui.I18n.getText('bitbucket.web.admin.storage.add.a.data.store'),
                        showCloseButton: false,
                        modal: true,
                        footerActionContent: _react2.default.createElement(FooterActionButtons, {
                            createStore: createStore,
                            onCloseDialog: onCloseDialog,
                            saving: saving,
                            validationRequired: !pathInfo
                        })
                    },
                    _react2.default.createElement(
                        'p',
                        null,
                        _react2.default.createElement(
                            'span',
                            { className: 'description-important' },
                            _aui.I18n.getText('bitbucket.web.admin.storage.dialog.description.bold')
                        ),
                        ' ',
                        _aui.I18n.getText('bitbucket.web.admin.storage.dialog.description')
                    ),
                    _react2.default.createElement(
                        'form',
                        { className: 'aui', onSubmit: validatePath },
                        _react2.default.createElement(
                            'fieldset',
                            { className: 'inline' },
                            _react2.default.createElement(
                                'div',
                                { className: 'field-group' },
                                _react2.default.createElement(
                                    'label',
                                    { htmlFor: 'path' },
                                    'Path'
                                ),
                                _react2.default.createElement('input', {
                                    type: 'text',
                                    name: 'path',
                                    className: 'text medium-long-field path-input',
                                    maxLength: MAX_PATH_LENGTH,
                                    onChange: onInputChange,
                                    ref: this.pathTextInput,
                                    value: path
                                }),
                                _react2.default.createElement('input', {
                                    type: 'submit',
                                    className: 'button submit validate-button',
                                    value: _aui.I18n.getText('bitbucket.web.admin.storage.check.path')
                                }),
                                _react2.default.createElement(
                                    'div',
                                    { className: 'description' },
                                    _aui.I18n.getText('bitbucket.web.admin.storage.dialog.add.directory.path'),
                                    ' ',
                                    _react2.default.createElement(
                                        'a',
                                        {
                                            href: bitbucket_help_url('bitbucket.help.storage'),
                                            target: '_blank'
                                        },
                                        _aui.I18n.getText('bitbucket.web.admin.storage.learn.more')
                                    )
                                ),
                                pathInfo ? _react2.default.createElement(
                                    'div',
                                    { className: 'successful-path' },
                                    _react2.default.createElement(
                                        'div',
                                        { className: 'description' },
                                        _react2.default.createElement(_icons.InfoFilledIcon, null),
                                        _aui.I18n.getText('bitbucket.web.admin.storage.dialog.path.name', pathInfo.description)
                                    ),
                                    _react2.default.createElement(
                                        'div',
                                        { className: 'description' },
                                        _aui.I18n.getText('bitbucket.web.admin.storage.dialog.storage.info', _text2.default.formatSizeInBytes(pathInfo.usedSpace), _text2.default.formatSizeInBytes(pathInfo.totalSpace), _text2.default.formatSizeInBytes(pathInfo.usableSpace))
                                    )
                                ) : null,
                                errors.length ? _react2.default.createElement(Errors, { errors: errors }) : null
                            )
                        )
                    )
                );
            }
        }]);

        return AddStoreDialog;
    }(_react.Component);

    AddStoreDialog.propTypes = {
        createStore: _propTypes2.default.func.isRequired,
        errors: _propTypes2.default.arrayOf(_propTypes2.default.object),
        path: _propTypes2.default.string,
        pathInfo: _propTypes2.default.object,
        onCloseDialog: _propTypes2.default.func.isRequired,
        onInputChange: _propTypes2.default.func.isRequired,
        saving: _propTypes2.default.bool,
        validatePath: _propTypes2.default.func.isRequired
    };
    exports.default = AddStoreDialog;
    module.exports = exports['default'];
});