define('bitbucket/internal/bbui/reducers/pull-request-can-merge', ['module', 'exports', 'bitbucket/internal/util/store/reducers', '../actions/pull-request', '../pull-request-header/actions', '../utils/merge-state-with-rollback'], function (module, exports, _reducers, _pullRequest, _actions, _mergeStateWithRollback) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _mergeStateWithRollback2 = _interopRequireDefault(_mergeStateWithRollback);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _reduceByType;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var defaultState = {
        canMerge: false,
        conflicted: null,
        vetoes: null,
        properties: null,
        isChecking: false,
        showDialog: false
    };

    exports.default = (0, _reducers.reduceByType)(defaultState, (_reduceByType = {}, _defineProperty(_reduceByType, _pullRequest.PR_CHECK_MERGEABILITY, function (state, action) {
        return (0, _mergeStateWithRollback2.default)(state, action, {
            forward: function forward() {
                return {
                    isChecking: true
                };
            },
            commit: function commit() {
                return _extends({}, action.payload, {
                    isChecking: false
                });
            }
        });
    }), _defineProperty(_reduceByType, _actions.PR_SHOW_MERGE_ERRORS, function (state, action) {
        return _extends({}, state, {
            showDialog: true
        });
    }), _defineProperty(_reduceByType, _actions.PR_HIDE_MERGE_ERRORS, function (state, action) {
        return _extends({}, state, {
            showDialog: false
        });
    }), _reduceByType));
    module.exports = exports['default'];
});