define('bitbucket/internal/bbui/pull-request-table/components/reviewers', ['module', 'exports', 'prop-types', 'react', 'bitbucket/internal/enums', '../../reviewer-avatar-list/reviewer-avatar-list'], function (module, exports, _propTypes, _react, _enums, _reviewerAvatarList) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _reviewerAvatarList2 = _interopRequireDefault(_reviewerAvatarList);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var MAX_OPEN = 3;

    var Reviewers = function (_Component) {
        _inherits(Reviewers, _Component);

        function Reviewers() {
            _classCallCheck(this, Reviewers);

            return _possibleConstructorReturn(this, (Reviewers.__proto__ || Object.getPrototypeOf(Reviewers)).apply(this, arguments));
        }

        _createClass(Reviewers, [{
            key: 'shouldComponentUpdate',
            value: function shouldComponentUpdate(newProps) {
                return this.props.pullRequest !== newProps.pullRequest || this.props.pullRequest.reviewers !== newProps.pullRequest.reviewers;
            }
        }, {
            key: 'render',
            value: function render() {
                var pullRequest = this.props.pullRequest;

                return _react2.default.createElement(
                    'td',
                    { className: 'reviewers' },
                    _react2.default.createElement(_reviewerAvatarList2.default, {
                        avatarSize: _enums.AvatarTShirtSize.MEDIUM,
                        currentUserAsReviewer: this.props.currentUser,
                        currentUserAvatarSize: this.props.currentUserAvatarSize,
                        dialogReviewersAsTooltip: this.props.dialogReviewersAsTooltip,
                        maxOpen: this.props.maxOpen || MAX_OPEN,
                        menuId: 'reviewers-' + pullRequest.id,
                        permissionToReview: false,
                        pullRequestIsOpen: pullRequest.state === 'OPEN',
                        reviewers: pullRequest.reviewers
                    })
                );
            }
        }]);

        return Reviewers;
    }(_react.Component);

    Reviewers.propTypes = {
        currentUser: _propTypes2.default.object,
        currentUserAvatarSize: _propTypes2.default.string,
        dialogReviewersAsTooltip: _reviewerAvatarList2.default.propTypes.dialogReviewersAsTooltip,
        pullRequest: _propTypes2.default.object.isRequired,
        maxOpen: _propTypes2.default.number
    };


    Reviewers.Header = function () {
        return _react2.default.createElement(
            'th',
            { className: 'reviewers', scope: 'col' },
            AJS.I18n.getText('bitbucket.pull.request.table.title.reviewers')
        );
    };

    exports.default = Reviewers;
    module.exports = exports['default'];
});