define('bitbucket/internal/bbui/history/HistoryManager', ['module', 'exports', 'bitbucket/internal/util/navigator', '../widget/widget'], function (module, exports, _navigator, _widget) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _widget2 = _interopRequireDefault(_widget);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var History = function (_Widget) {
        _inherits(History, _Widget);

        function History(localWindow) {
            _classCallCheck(this, History);

            var _this = _possibleConstructorReturn(this, (History.__proto__ || Object.getPrototypeOf(History)).call(this));

            _this._localWindow = localWindow || window;
            _this.titleSuffix = '';
            _this._init();
            return _this;
        }

        _createClass(History, [{
            key: 'pushState',
            value: function pushState(state, title, url) {
                this._localWindow.history.pushState(state, title || '', url || '');
                this._maybeSetTitle(title);
                this.trigger('changestate', { state: state });
            }
        }, {
            key: 'replaceState',
            value: function replaceState(state, title, url) {
                this._localWindow.history.replaceState(state, title || '', url || '');
                this._maybeSetTitle(title);
                this.trigger('changestate', { state: state });
            }
        }, {
            key: 'state',
            value: function state() {
                return this._localWindow.history.state;
            }
        }, {
            key: 'initialState',
            value: function initialState(state) {
                return this._localWindow.history.replaceState(state, '', this._localWindow.location.href);
            }
        }, {
            key: 'setTitleSuffix',
            value: function setTitleSuffix(suffix) {
                this.titleSuffix = suffix || '';
            }
        }, {
            key: '_init',
            value: function _init() {
                var _this2 = this;

                //Safari fires an event on every page load. We want to swallow this event.
                var skipNextPop = (0, _navigator.isSafari)();
                var listener = function listener(e) {
                    //The initial event in Safari has event.state === null so if the first event has some state
                    //then let it through.
                    if (e && (!skipNextPop || e.state !== null)) {
                        _this2.trigger('popstate', e);
                        _this2.trigger('changestate', e);
                    }

                    if (skipNextPop) {
                        skipNextPop = false;
                    }
                };
                this._localWindow.addEventListener('popstate', listener);

                this._addDestroyable(function () {
                    _this2._localWindow.removeEventListener('popstate', listener);
                });
            }
        }, {
            key: '_maybeSetTitle',
            value: function _maybeSetTitle(title) {
                if (title) {
                    this._localWindow.document.title = title + this.titleSuffix;
                }
            }
        }]);

        return History;
    }(_widget2.default);

    exports.default = History;
    module.exports = exports['default'];
});