define('bitbucket/internal/bbui/filter-bar/filter-bar', ['exports', 'jquery', 'lodash', 'prop-types', 'react', './components/async-select', './components/filter', './components/select', './components/toggle'], function (exports, _jquery, _lodash, _propTypes, _react, _asyncSelect, _filter, _select, _toggle) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.Toggle = exports.Select = exports.AsyncSelect = undefined;

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _asyncSelect2 = _interopRequireDefault(_asyncSelect);

    var _filter2 = _interopRequireDefault(_filter);

    var _select2 = _interopRequireDefault(_select);

    var _toggle2 = _interopRequireDefault(_toggle);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                arr2[i] = arr[i];
            }

            return arr2;
        } else {
            return Array.from(arr);
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    /**
     * Calls React.cloneElement, but for any props that already contains callbacks, combines the callbacks and ensures both the old version
     * and new version are called.
     *
     * If you've got a better name, and I'm sure you do, please rename this.
     *
     * @param {ReactElement} el - el to clone
     * @param {Object} newProps - properties to override
     * @returns {ReactElement}
     */
    function cloneSequencedOverwrite(el, newProps) {
        var combinedProps = _lodash2.default.cloneWith(newProps, function (newVal, prop) {
            var elVal = el[prop];
            if (!_lodash2.default.isFunction(elVal) || !_lodash2.default.isFunction(newVal)) {
                return newVal;
            }
            return function () {
                elVal.apply(el, arguments);
                newVal.apply(el, arguments);
            };
        });
        return _react2.default.cloneElement(el, combinedProps);
    }

    var FilterBar = function (_Component) {
        _inherits(FilterBar, _Component);

        function FilterBar() {
            var _ref;

            _classCallCheck(this, FilterBar);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            var _this = _possibleConstructorReturn(this, (_ref = FilterBar.__proto__ || Object.getPrototypeOf(FilterBar)).call.apply(_ref, [this].concat(args)));

            _this.filterRefs = [];
            return _this;
        }

        _createClass(FilterBar, [{
            key: 'getState',
            value: function getState() {
                var state = {};
                this.filterRefs.forEach(function (filter) {
                    if (!filter) {
                        return;
                    }
                    state[filter.props.id] = filter.domValue();
                });
                return state;
            }
        }, {
            key: 'set',
            value: function set(newState) {
                var _this2 = this;

                var oldState = this.getState();
                var resetPromises = this.filterRefs.map(function (filter) {
                    if (!filter || newState[filter.props.id] === undefined) {
                        return _jquery2.default.Deferred().resolve();
                    }
                    return filter.set(newState[filter.props.id]);
                });
                _jquery2.default.when.apply(_jquery2.default, _toConsumableArray(resetPromises)).then(function () {
                    newState = _this2.getState();
                    if (Object.keys(newState).some(function (prop) {
                        return newState[prop] !== oldState[prop];
                    })) {
                        _this2.props.onChange(newState);
                    }
                });
            }
        }, {
            key: 'render',
            value: function render() {
                var _this3 = this;

                var onChange = void 0;
                if (this.props.onChange) {
                    onChange = function onChange() {
                        _this3.props.onChange(_this3.getState());
                    };
                }

                return _react2.default.createElement(
                    'div',
                    { className: 'filter-bar', id: this.props.id },
                    _react2.default.createElement(
                        'h6',
                        { className: 'filter-label' },
                        AJS.I18n.getText('bitbucket.component.filter.bar.label')
                    ),
                    _react2.default.createElement(
                        'ul',
                        null,
                        _react2.default.Children.map(this.props.children, function (c, i) {
                            if (!c || !(c.type.prototype instanceof _filter2.default)) {
                                return c;
                            }
                            return cloneSequencedOverwrite(c, {
                                onChange: onChange || undefined,
                                ref: function ref(r) {
                                    return _this3.filterRefs[i] = r;
                                }
                            });
                        })
                    )
                );
            }
        }]);

        return FilterBar;
    }(_react.Component);

    FilterBar.propTypes = {
        children: _propTypes2.default.any,
        onChange: _propTypes2.default.func,
        id: _propTypes2.default.string
    };
    exports.default = FilterBar;
    exports.AsyncSelect = _asyncSelect2.default;
    exports.Select = _select2.default;
    exports.Toggle = _toggle2.default;
});