define('bitbucket/internal/bbui/aui-react/tabs', ['exports', 'classnames', 'prop-types', 'react'], function (exports, _classnames, _propTypes, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.Tabs = exports.Tab = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var Tab = exports.Tab = function Tab(_ref) {
        var children = _ref.children;

        return _react2.default.createElement(
            'div',
            { className: 'tabs-pane active-pane' },
            children
        );
    };

    Tab.propTypes = {
        title: _propTypes2.default.string.isRequired,
        children: _propTypes2.default.node.isRequired
    };

    var Tabs = exports.Tabs = function (_React$Component) {
        _inherits(Tabs, _React$Component);

        function Tabs(props) {
            _classCallCheck(this, Tabs);

            var _this = _possibleConstructorReturn(this, (Tabs.__proto__ || Object.getPrototypeOf(Tabs)).call(this, props));

            _this.onChange = function (index) {
                _this.setState(function () {
                    return {
                        selectedIndex: index
                    };
                });
            };

            _this.state = {
                selectedIndex: props.startingIndex || 0
            };
            return _this;
        }

        _createClass(Tabs, [{
            key: 'render',
            value: function render() {
                var _this2 = this;

                var _props = this.props,
                    children = _props.children,
                    className = _props.className;
                var selectedIndex = this.state.selectedIndex;


                var activeTab = _react2.default.Children.toArray(children)[selectedIndex];

                return _react2.default.createElement(
                    'div',
                    { className: 'aui-tabs horizontal-tabs ' + (className || '') },
                    _react2.default.createElement(
                        'ul',
                        { className: 'tabs-menu' },
                        _react2.default.Children.map(children, function (x, index) {
                            return _react2.default.createElement(
                                'li',
                                {
                                    className: (0, _classnames2.default)('menu-item', {
                                        'active-tab': index === selectedIndex
                                    })
                                },
                                _react2.default.createElement(
                                    'a',
                                    { onClick: function onClick() {
                                            return _this2.onChange(index);
                                        }, role: 'button', tabIndex: 0 },
                                    x.props.title
                                )
                            );
                        })
                    ),
                    activeTab
                );
            }
        }]);

        return Tabs;
    }(_react2.default.Component);

    Tabs.propTypes = {
        children: _propTypes2.default.node.isRequired,
        onChange: _propTypes2.default.func,
        startingIndex: _propTypes2.default.number,
        className: _propTypes2.default.string
    };
});