define('bitbucket/internal/bbui/aui-react/spinner', ['exports', 'prop-types', 'react', 'bitbucket/internal/util/components/react-functional', '@atlassian/aui'], function (exports, _propTypes, _react, _reactFunctional) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.SpinnerSize = undefined;

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var SpinnerSize = exports.SpinnerSize = {
        SMALL: 'small',
        MEDIUM: 'medium',
        LARGE: 'large'
    }; // We depend on the spinner


    function Spinner(_ref) {
        var size = _ref.size,
            filled = _ref.filled;

        return _react2.default.createElement('aui-spinner', { size: size, filled: filled ? '' : undefined });
    }

    Spinner.propTypes = {
        size: _propTypes2.default.oneOf([SpinnerSize.SMALL, SpinnerSize.MEDIUM, SpinnerSize.LARGE]),
        filled: _propTypes2.default.bool
    };

    Spinner.defaultProps = {
        size: SpinnerSize.SMALL, // Although, AUI is using "medium" as a default size
        filled: false
    };

    exports.default = (0, _reactFunctional.pure)(Spinner);
});