define('bitbucket/internal/bbui/aui-react/component', ['module', 'exports', 'classnames', 'lodash', 'prop-types', 'react', 'react-dom'], function (module, exports, _classnames, _lodash, _propTypes, _react, _reactDom) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _classnames2 = _interopRequireDefault(_classnames);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _reactDom2 = _interopRequireDefault(_reactDom);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var propTypes = {
        children: _propTypes2.default.node.isRequired,
        containerSelector: _propTypes2.default.string, // eg. we need to render into the '.aui-inline-dialog-contents' of an aui-inline-dialog
        id: _propTypes2.default.string,
        markup: _propTypes2.default.string.isRequired,
        wrapperClass: _propTypes2.default.string // the wrapper class can be helpful when a very specific CSS selector is required for AUI
    };

    var AUIComponent = function (_Component) {
        _inherits(AUIComponent, _Component);

        function AUIComponent() {
            _classCallCheck(this, AUIComponent);

            return _possibleConstructorReturn(this, (AUIComponent.__proto__ || Object.getPrototypeOf(AUIComponent)).apply(this, arguments));
        }

        _createClass(AUIComponent, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                var _this2 = this;

                var node = _reactDom2.default.findDOMNode(this);
                node.innerHTML = this.props.markup;
                node.firstChild.id = this.props.id;
                _lodash2.default.defer(function () {
                    return _this2.updateContent();
                });
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate() {
                this.updateContent();
            }
        }, {
            key: 'componentWillUnmount',
            value: function componentWillUnmount() {
                _reactDom2.default.unmountComponentAtNode(this.getContainer());
                // if there is an ID also try to remove the component with that ID.
                // This should take care of any container elements that AUI has moved.
                if (this.props.id) {
                    var el = document.querySelector('#' + this.props.id);
                    if (el) {
                        el.parentNode.removeChild(el); // update when we drop IE11 support
                    }
                }
            }
        }, {
            key: 'getContainer',
            value: function getContainer() {
                if (this._container) {
                    return this._container;
                }
                var containerSelector = this.props.containerSelector || '#' + this.props.id;
                this._container = document.querySelector(containerSelector);
                return this._container;
            }
        }, {
            key: 'updateContent',
            value: function updateContent() {
                var content = _react2.default.createElement(
                    'div',
                    { className: (0, _classnames2.default)(this.props.wrapperClass) },
                    this.props.children
                );
                if (this.getContainer()) {
                    _reactDom2.default.render(content, this.getContainer());
                }
            }
        }, {
            key: 'render',
            value: function render() {
                return _react2.default.createElement('div', null);
            }
        }]);

        return AUIComponent;
    }(_react.Component);

    AUIComponent.propTypes = propTypes;

    exports.default = AUIComponent;
    module.exports = exports['default'];
});