/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util.web;

import com.atlassian.stash.internal.web.util.web.FilterServletInputStream;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletInputStream;

public class CountingServletInputStream
extends FilterServletInputStream {
    private long count;
    private long mark = -1L;

    public CountingServletInputStream(ServletInputStream in) {
        super(in);
    }

    public long getBytesRead() {
        return this.count;
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.count;
    }

    public int read() throws IOException {
        int result = this.in.read();
        if (result != -1) {
            ++this.count;
        }
        return result;
    }

    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        int result = this.in.read(b, off, len);
        if (result != -1) {
            this.count += (long)result;
        }
        return result;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.count = this.mark;
    }

    public long skip(long n) throws IOException {
        long result = this.in.skip(n);
        this.count += result;
        return result;
    }
}

