/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util.captcha;

import com.atlassian.stash.internal.web.util.captcha.CensoringWordGenerator;
import com.google.common.collect.ImmutableList;
import com.jhlabs.image.PinchFilter;
import com.octo.captcha.component.image.backgroundgenerator.BackgroundGenerator;
import com.octo.captcha.component.image.backgroundgenerator.UniColorBackgroundGenerator;
import com.octo.captcha.component.image.color.ColorGenerator;
import com.octo.captcha.component.image.color.RandomListColorGenerator;
import com.octo.captcha.component.image.deformation.ImageDeformation;
import com.octo.captcha.component.image.deformation.ImageDeformationByBufferedImageOp;
import com.octo.captcha.component.image.fontgenerator.FontGenerator;
import com.octo.captcha.component.image.fontgenerator.RandomFontGenerator;
import com.octo.captcha.component.image.textpaster.GlyphsPaster;
import com.octo.captcha.component.image.textpaster.TextPaster;
import com.octo.captcha.component.image.textpaster.glyphsvisitor.GlyphsVisitors;
import com.octo.captcha.component.image.textpaster.glyphsvisitor.OverlapGlyphsUsingShapeVisitor;
import com.octo.captcha.component.image.textpaster.glyphsvisitor.RotateGlyphsRandomVisitor;
import com.octo.captcha.component.image.textpaster.glyphsvisitor.TranslateAllToRandomPointVisitor;
import com.octo.captcha.component.image.textpaster.glyphsvisitor.TranslateGlyphsVerticalRandomVisitor;
import com.octo.captcha.component.image.wordtoimage.DeformedComposedWordToImage;
import com.octo.captcha.component.image.wordtoimage.WordToImage;
import com.octo.captcha.component.word.DictionaryReader;
import com.octo.captcha.component.word.FileDictionary;
import com.octo.captcha.component.word.wordgenerator.ComposeDictionaryWordGenerator;
import com.octo.captcha.component.word.wordgenerator.WordGenerator;
import com.octo.captcha.engine.image.ListImageCaptchaEngine;
import com.octo.captcha.image.ImageCaptchaFactory;
import com.octo.captcha.image.gimpy.GimpyFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.image.BufferedImageOp;
import java.util.Collections;
import java.util.List;

public class StashCaptchaEngine
extends ListImageCaptchaEngine {
    private static final int CAPTCHA_HEIGHT = 100;
    private static final int CAPTCHA_WIDTH = 230;

    protected void buildInitialFactories() {
        GlyphsPaster textPaster = new GlyphsPaster(Integer.valueOf(6), Integer.valueOf(8), (ColorGenerator)new RandomListColorGenerator(this.getTextColors()), new GlyphsVisitors[]{new RotateGlyphsRandomVisitor(0.08726646259971647), new TranslateGlyphsVerticalRandomVisitor(1.0), new OverlapGlyphsUsingShapeVisitor(3.0), new TranslateAllToRandomPointVisitor(5.0, 5.0)});
        DeformedComposedWordToImage wordToImage = new DeformedComposedWordToImage(false, (FontGenerator)new RandomFontGenerator(Integer.valueOf(60), Integer.valueOf(70), this.getFonts(), false), (BackgroundGenerator)new UniColorBackgroundGenerator(Integer.valueOf(230), Integer.valueOf(100), Color.white), (TextPaster)textPaster, Collections.emptyList(), this.getTextDeformations(), Collections.emptyList());
        GimpyFactory factory = new GimpyFactory(this.getWordGenerator(), (WordToImage)wordToImage, false);
        this.addFactory((ImageCaptchaFactory)factory);
    }

    private Font[] getFonts() {
        return new Font[]{Font.decode("Serif"), Font.decode("SansSerif"), Font.decode("Monospaced"), Font.decode("Dialog"), Font.decode("DialogInput")};
    }

    private Color[] getTextColors() {
        return new Color[]{new Color(6, 148, 10), new Color(10, 34, 140), new Color(196, 47, 14), new Color(222, 132, 42), new Color(91, 6, 140)};
    }

    private List<ImageDeformation> getTextDeformations() {
        return ImmutableList.of((Object)this.pinchDeformation(0.25f, -0.01f, -0.6f), (Object)this.pinchDeformation(0.33f, 1.01f, -0.6f), (Object)this.pinchDeformation(0.75f, -0.01f, -0.5f));
    }

    private WordGenerator getWordGenerator() {
        return new CensoringWordGenerator((WordGenerator)new ComposeDictionaryWordGenerator((DictionaryReader)new FileDictionary("toddlist")));
    }

    private ImageDeformation pinchDeformation(float x, float y, float amount) {
        PinchFilter pinch = new PinchFilter();
        pinch.setAmount(amount);
        pinch.setRadius(80.0f);
        pinch.setAngle(0.19634955f);
        pinch.setCentreX(x);
        pinch.setCentreY(y);
        pinch.setEdgeAction(1);
        return new ImageDeformationByBufferedImageOp((BufferedImageOp)pinch);
    }
}

