/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.web.util.captcha;

import com.atlassian.stash.internal.web.util.captcha.HazelcastCaptchaStore;
import com.google.common.collect.ImmutableSet;
import com.hazelcast.core.IMap;
import com.hazelcast.map.EntryProcessor;
import com.octo.captcha.Captcha;
import com.octo.captcha.service.CaptchaServiceException;
import com.octo.captcha.service.captchastore.CaptchaAndLocale;
import com.octo.captcha.service.captchastore.CaptchaStore;
import java.util.Collection;
import java.util.Locale;

public class HazelcastCaptchaStore
implements CaptchaStore {
    private final IMap<String, CaptchaAndLocale> captchas;

    public HazelcastCaptchaStore(IMap<String, CaptchaAndLocale> captchas) {
        this.captchas = captchas;
    }

    public void cleanAndShutdown() {
        this.captchas.clear();
    }

    public void empty() {
        this.captchas.clear();
    }

    public Captcha getCaptcha(String id) throws CaptchaServiceException {
        CaptchaAndLocale value = (CaptchaAndLocale)this.captchas.get((Object)id);
        return value != null ? value.getCaptcha() : null;
    }

    public Collection getKeys() {
        return ImmutableSet.copyOf((Collection)this.captchas.keySet());
    }

    public Locale getLocale(String id) throws CaptchaServiceException {
        CaptchaAndLocale value = (CaptchaAndLocale)this.captchas.get((Object)id);
        return value != null ? value.getLocale() : null;
    }

    public int getSize() {
        return this.captchas.size();
    }

    public boolean hasCaptcha(String id) {
        return this.captchas.containsKey((Object)id);
    }

    public void initAndStart() {
    }

    public boolean removeCaptcha(String id) {
        return Boolean.TRUE.equals(this.captchas.executeOnKey((Object)id, (EntryProcessor)new RemoveCaptchaEntryProcessor(null)));
    }

    public void storeCaptcha(String id, Captcha captcha) throws CaptchaServiceException {
        this.captchas.set((Object)id, (Object)new CaptchaAndLocale(captcha));
    }

    public void storeCaptcha(String id, Captcha captcha, Locale locale) throws CaptchaServiceException {
        this.captchas.set((Object)id, (Object)new CaptchaAndLocale(captcha, locale));
    }
}

